package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.ImplementationComponentType;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public abstract class JavaCoreXpt {
  @Inject
  private M2TFileSystemAccess fsa;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private DataTypesXpt _dataTypesXpt;

  @Inject
  @Extension
  private SEFFBodyXpt _sEFFBodyXpt;

  @Inject
  @Extension
  private ProvidedPortsXpt _providedPortsXpt;

  @Inject
  @Extension
  private ContextPatternXpt _contextPatternXpt;

  public CharSequence classHeader(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public class ");
    String _javaName = this._javaNamesExt.javaName(component);
    _builder.append(_javaName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence operationSignature(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _returnTypeTM = this.returnTypeTM(signature);
    _builder.append(_returnTypeTM);
    _builder.newLineIfNotEmpty();
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature);
    _builder.newLineIfNotEmpty();
    _builder.append("( ");
    CharSequence _parameterListTM = this.parameterListTM(signature);
    _builder.append(_parameterListTM);
    _builder.append(" )");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence infrastructureSignature(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _returnTypeTM = this.returnTypeTM(signature);
    _builder.append(_returnTypeTM);
    _builder.newLineIfNotEmpty();
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature);
    _builder.newLineIfNotEmpty();
    _builder.append("( ");
    CharSequence _parameterListTM = this.parameterListTM(signature);
    _builder.append(_parameterListTM);
    _builder.append(" )");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _returnType(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    {
      DataType _returnType__OperationSignature = signature.getReturnType__OperationSignature();
      boolean _notEquals = (!Objects.equal(_returnType__OperationSignature, null));
      if (_notEquals) {
        String _dataType = this._dataTypesXpt.dataType(signature.getReturnType__OperationSignature());
        _builder.append(_dataType);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("void");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _returnType(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("void");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _returnTypeTM(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _returnTypeTM(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parameterListTM(final Signature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parameterUsageListTM(final Signature signature) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parameter(final Parameter param) {
    StringConcatenation _builder = new StringConcatenation();
    {
      DataType _dataType__Parameter = param.getDataType__Parameter();
      boolean _notEquals = (!Objects.equal(_dataType__Parameter, null));
      if (_notEquals) {
        String _dataType = this._dataTypesXpt.dataType(param.getDataType__Parameter());
        _builder.append(_dataType);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("void");
        _builder.newLine();
      }
    }
    String _parameterName = param.getParameterName();
    _builder.append(_parameterName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence parameterUse(final Parameter param) {
    StringConcatenation _builder = new StringConcatenation();
    String _parameterName = param.getParameterName();
    _builder.append(_parameterName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence componentService(final ServiceEffectSpecification seff) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _componentServiceSignature(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _returnTypeTM = this.returnTypeTM(signature);
    _builder.append(_returnTypeTM);
    _builder.append("\t");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(signature.getInterface__OperationSignature()));
    _builder.append(_firstLower);
    _builder.append("_");
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature);
    _builder.append("(");
    CharSequence _parameterListTM = this.parameterListTM(signature);
    _builder.append(_parameterListTM);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentServiceSignature(final InfrastructureSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _returnTypeTM = this.returnTypeTM(signature);
    _builder.append(_returnTypeTM);
    _builder.append("\t");
    String _firstLower = StringExtensions.toFirstLower(this._javaNamesExt.javaName(signature.getInfrastructureInterface__InfrastructureSignature()));
    _builder.append(_firstLower);
    _builder.append("_");
    String _javaSignature = this._javaNamesExt.javaSignature(signature);
    _builder.append(_javaSignature);
    _builder.append("(");
    CharSequence _parameterListTM = this.parameterListTM(signature);
    _builder.append(_parameterListTM);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentServiceTM(final OperationSignature signature, final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _componentServiceTM(final InfrastructureSignature signature, final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public String actions(final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _action = this._sEFFBodyXpt.action(action);
    _builder.append(_action);
    _builder.newLineIfNotEmpty();
    {
      if ((!(action instanceof StopAction))) {
        String _actions = this.actions(action.getSuccessor_AbstractAction());
        _builder.append(_actions);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  protected CharSequence _componentImplementation(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _componentImplementation(final ImplementationComponentType component) {
    StringConcatenation _builder = new StringConcatenation();
    this.componentImplementationForImplComponentTypesAndSubSystems(component);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _componentImplementation(final SubSystem system) {
    StringConcatenation _builder = new StringConcatenation();
    this.componentImplementationForImplComponentTypesAndSubSystems(system);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public void componentImplementationForImplComponentTypesAndSubSystems(final RepositoryComponent component) {
    final String fileName = this._javaNamesExt.getFileName(component);
    StringConcatenation _builder = new StringConcatenation();
    this.componentImplementationInterface(component);
    _builder.newLineIfNotEmpty();
    CharSequence _componentPackage = this.componentPackage(component);
    _builder.append(_componentPackage);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _classHeader = this.classHeader(component);
    _builder.append(_classHeader);
    _builder.newLineIfNotEmpty();
    CharSequence _superClassesTM = this.superClassesTM(component);
    _builder.append(_superClassesTM);
    _builder.newLineIfNotEmpty();
    _builder.append("implements ");
    String _fqnInterface = this._javaNamesExt.fqnInterface(component);
    _builder.append(_fqnInterface);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _componentConstructorTM = this.componentConstructorTM(component);
    _builder.append(_componentConstructorTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _providedPorts = this._providedPortsXpt.providedPorts(component);
    _builder.append(_providedPorts, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _requiredInterfaces = this._contextPatternXpt.requiredInterfaces(component);
    _builder.append(_requiredInterfaces, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _innerImplementation = this.innerImplementation(component);
    _builder.append(_innerImplementation, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _specificImplementationPartTM = this.specificImplementationPartTM(component);
    _builder.append(_specificImplementationPartTM, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    CharSequence _componentImplementationChildClassTM = this.componentImplementationChildClassTM(component);
    _builder.append(_componentImplementationChildClassTM);
    _builder.newLineIfNotEmpty();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence componentPackage(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(component);
    _builder.append(_implementationPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public void componentImplementationInterface(final InterfaceProvidingEntity entity) {
    String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(this._javaNamesExt.fqnInterface(entity));
    final String fileName = (_fqnToDirectoryPath + ".java");
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _contentImplementationInterfaceHeader = this.contentImplementationInterfaceHeader(entity);
    _builder.append(_contentImplementationInterfaceHeader);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _componentHelperMethodsDeclarationTM = this.componentHelperMethodsDeclarationTM(entity);
    _builder.append(_componentHelperMethodsDeclarationTM, "\t");
    _builder.append("\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final Function1<OperationProvidedRole, EList<OperationSignature>> _function = (OperationProvidedRole it) -> {
      return it.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
    };
    final Function1<OperationSignature, CharSequence> _function_1 = (OperationSignature it) -> {
      return this.componentServiceSignature(it);
    };
    String _join = IterableExtensions.join(IterableExtensions.<OperationSignature, CharSequence>map(Iterables.<OperationSignature>concat(IterableExtensions.<OperationProvidedRole, EList<OperationSignature>>map(Iterables.<OperationProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class), _function)), _function_1), ";");
    _builder.append(_join, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final Function1<InfrastructureProvidedRole, EList<InfrastructureSignature>> _function_2 = (InfrastructureProvidedRole it) -> {
      return it.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface();
    };
    final Function1<InfrastructureSignature, CharSequence> _function_3 = (InfrastructureSignature it) -> {
      return this.componentServiceSignature(it);
    };
    String _join_1 = IterableExtensions.join(IterableExtensions.<InfrastructureSignature, CharSequence>map(Iterables.<InfrastructureSignature>concat(IterableExtensions.<InfrastructureProvidedRole, EList<InfrastructureSignature>>map(Iterables.<InfrastructureProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class), _function_2)), _function_3), ";");
    _builder.append(_join_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    {
      Iterable<OperationProvidedRole> _filter = Iterables.<OperationProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class);
      for(final OperationProvidedRole providedRole : _filter) {
        _builder.append("\t");
        CharSequence _portGetterDefinition = this._providedPortsXpt.portGetterDefinition(providedRole);
        _builder.append(_portGetterDefinition, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<InfrastructureProvidedRole> _filter_1 = Iterables.<InfrastructureProvidedRole>filter(entity.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class);
      for(final InfrastructureProvidedRole providedRole_1 : _filter_1) {
        _builder.append("\t");
        CharSequence _portGetterDefinition_1 = this._providedPortsXpt.portGetterDefinition(providedRole_1);
        _builder.append(_portGetterDefinition_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((entity instanceof InterfaceProvidingRequiringEntity)) {
        _builder.append("\t");
        CharSequence _xblockexpression = null;
        {
          final InterfaceProvidingRequiringEntity requiringEntity = ((InterfaceProvidingRequiringEntity) entity);
          _xblockexpression = this._contextPatternXpt.componentContextSetterDefinition(requiringEntity);
        }
        _builder.append(_xblockexpression, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((entity instanceof RepositoryComponent)) {
        _builder.append("\t");
        CharSequence _xblockexpression_1 = null;
        {
          final RepositoryComponent requiringEntity = ((RepositoryComponent) entity);
          _xblockexpression_1 = this.specificImplementationPartForInterfaceTM(requiringEntity);
        }
        _builder.append(_xblockexpression_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    final String fileContent = _builder.toString();
    this.fsa.generateFile(fileName, fileContent);
  }

  public CharSequence contentImplementationInterfaceHeader(final InterfaceProvidingEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _implementationPackage = this._javaNamesExt.implementationPackage(entity);
    _builder.append(_implementationPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public interface ");
    String _interfaceName = this._javaNamesExt.interfaceName(entity);
    _builder.append(_interfaceName);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence componentHelperMethodsDeclarationTM(final InterfaceProvidingEntity entity) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence componentImplementationChildClassTM(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence specificImplementationPartTM(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence specificImplementationPartForInterfaceTM(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence superClassesTM(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _innerImplementation(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _innerImplementation(final BasicComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<OperationProvidedRole, EList<OperationSignature>> _function = (OperationProvidedRole it) -> {
        return it.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
      };
      Iterable<OperationSignature> _flatten = Iterables.<OperationSignature>concat(IterableExtensions.<OperationProvidedRole, EList<OperationSignature>>map(Iterables.<OperationProvidedRole>filter(component.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class), _function));
      for(final OperationSignature iface : _flatten) {
        CharSequence _componentServiceTM = this.componentServiceTM(iface, component);
        _builder.append(_componentServiceTM);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      final Function1<InfrastructureProvidedRole, EList<InfrastructureSignature>> _function_1 = (InfrastructureProvidedRole it) -> {
        return it.getProvidedInterface__InfrastructureProvidedRole().getInfrastructureSignatures__InfrastructureInterface();
      };
      Iterable<InfrastructureSignature> _flatten_1 = Iterables.<InfrastructureSignature>concat(IterableExtensions.<InfrastructureProvidedRole, EList<InfrastructureSignature>>map(Iterables.<InfrastructureProvidedRole>filter(component.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class), _function_1));
      for(final InfrastructureSignature iface_1 : _flatten_1) {
        CharSequence _componentServiceTM_1 = this.componentServiceTM(iface_1, component);
        _builder.append(_componentServiceTM_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _innerImplementation(final CompositeComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence componentConstructorTM(final RepositoryComponent component) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence containerAvailabilityCheckTM(final OperationSignature signature) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence contextTypeTM(final AbstractAction action) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public CharSequence returnType(final Signature signature) {
    if (signature instanceof InfrastructureSignature) {
      return _returnType((InfrastructureSignature)signature);
    } else if (signature instanceof OperationSignature) {
      return _returnType((OperationSignature)signature);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature).toString());
    }
  }

  public CharSequence returnTypeTM(final Signature signature) {
    if (signature instanceof InfrastructureSignature) {
      return _returnTypeTM((InfrastructureSignature)signature);
    } else if (signature instanceof OperationSignature) {
      return _returnTypeTM((OperationSignature)signature);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature).toString());
    }
  }

  public CharSequence componentServiceSignature(final Signature signature) {
    if (signature instanceof InfrastructureSignature) {
      return _componentServiceSignature((InfrastructureSignature)signature);
    } else if (signature instanceof OperationSignature) {
      return _componentServiceSignature((OperationSignature)signature);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature).toString());
    }
  }

  public CharSequence componentServiceTM(final Signature signature, final RepositoryComponent component) {
    if (signature instanceof InfrastructureSignature) {
      return _componentServiceTM((InfrastructureSignature)signature, component);
    } else if (signature instanceof OperationSignature) {
      return _componentServiceTM((OperationSignature)signature, component);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(signature, component).toString());
    }
  }

  public CharSequence componentImplementation(final RepositoryComponent component) {
    if (component instanceof ImplementationComponentType) {
      return _componentImplementation((ImplementationComponentType)component);
    } else if (component instanceof SubSystem) {
      return _componentImplementation((SubSystem)component);
    } else if (component != null) {
      return _componentImplementation(component);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(component).toString());
    }
  }

  public CharSequence innerImplementation(final RepositoryComponent component) {
    if (component instanceof BasicComponent) {
      return _innerImplementation((BasicComponent)component);
    } else if (component instanceof CompositeComponent) {
      return _innerImplementation((CompositeComponent)component);
    } else if (component != null) {
      return _innerImplementation(component);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(component).toString());
    }
  }
}
