package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.pcm.transformations.Helper;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.DelegationConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

@SuppressWarnings("all")
public class PCMext {
  public StartAction findStart(final List<AbstractAction> actions) {
    return IterableExtensions.<StartAction>head(Iterables.<StartAction>filter(actions, StartAction.class));
  }

  public Iterable<Connector> connectors(final ComposedStructure s) {
    final Function1<Connector, Boolean> _function = (Connector connector) -> {
      return Boolean.valueOf((!(connector instanceof DelegationConnector)));
    };
    return IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function);
  }

  protected boolean _test(final Connector conn, final AssemblyContext ctx, final RequiredRole r) {
    return false;
  }

  protected boolean _test(final AssemblyConnector c, final AssemblyContext ctx, final RequiredRole r) {
    return (c.getRequiredRole_AssemblyConnector().getId().equals(r.getId()) && 
      c.getRequiringAssemblyContext_AssemblyConnector().getId().equals(ctx.getId()));
  }

  protected boolean _test(final AssemblyInfrastructureConnector c, final AssemblyContext ctx, final InfrastructureRequiredRole r) {
    return (c.getRequiredRole__AssemblyInfrastructureConnector().getId().equals(r.getId()) && 
      c.getRequiringAssemblyContext__AssemblyInfrastructureConnector().getId().equals(ctx.getId()));
  }

  protected boolean _test(final AssemblyEventConnector c, final AssemblyContext ctx, final SinkRole r) {
    return (c.getSinkRole__AssemblyEventConnector().getId().equals(r.getId()) && 
      c.getSourceAssemblyContext__AssemblyEventConnector().getId().equals(ctx.getId()));
  }

  public boolean hasConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<Connector, Boolean> _function = (Connector con) -> {
      return Boolean.valueOf(this.test(con, ctx, r));
    };
    int _size = IterableExtensions.size(IterableExtensions.<Connector>filter(this.connectors(s), _function));
    return (_size == 1);
  }

  public Connector getConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<Connector, Boolean> _function = (Connector con) -> {
      return Boolean.valueOf(this.test(con, ctx, r));
    };
    return IterableExtensions.<Connector>head(IterableExtensions.<Connector>filter(this.connectors(s), _function));
  }

  public boolean hasProvidedDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    final Function1<ProvidedDelegationConnector, Boolean> _function = (ProvidedDelegationConnector dc) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
    };
    int _size = IterableExtensions.size(IterableExtensions.<ProvidedDelegationConnector>filter(Iterables.<ProvidedDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), _function));
    return (_size == 1);
  }

  public boolean hasProvidedInfrastructureDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    final Function1<ProvidedInfrastructureDelegationConnector, Boolean> _function = (ProvidedInfrastructureDelegationConnector dc) -> {
      InfrastructureProvidedRole _outerProvidedRole__ProvidedInfrastructureDelegationConnector = dc.getOuterProvidedRole__ProvidedInfrastructureDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole__ProvidedInfrastructureDelegationConnector, p));
    };
    int _size = IterableExtensions.size(IterableExtensions.<ProvidedInfrastructureDelegationConnector>filter(Iterables.<ProvidedInfrastructureDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedInfrastructureDelegationConnector.class), _function));
    return (_size == 1);
  }

  public ProvidedDelegationConnector getProvidedDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    final Function1<ProvidedDelegationConnector, Boolean> _function = (ProvidedDelegationConnector dc) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
    };
    return IterableExtensions.<ProvidedDelegationConnector>head(IterableExtensions.<ProvidedDelegationConnector>filter(Iterables.<ProvidedDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), _function));
  }

  public ProvidedInfrastructureDelegationConnector getProvidedInfastructureDelegationConnector(final ComposedStructure s, final ProvidedRole p) {
    final Function1<ProvidedInfrastructureDelegationConnector, Boolean> _function = (ProvidedInfrastructureDelegationConnector dc) -> {
      InfrastructureProvidedRole _outerProvidedRole__ProvidedInfrastructureDelegationConnector = dc.getOuterProvidedRole__ProvidedInfrastructureDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole__ProvidedInfrastructureDelegationConnector, p));
    };
    return IterableExtensions.<ProvidedInfrastructureDelegationConnector>head(IterableExtensions.<ProvidedInfrastructureDelegationConnector>filter(Iterables.<ProvidedInfrastructureDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedInfrastructureDelegationConnector.class), _function));
  }

  public boolean hasRequiredDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<RequiredDelegationConnector, Boolean> _function = (RequiredDelegationConnector dc) -> {
      OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
    };
    int _size = IterableExtensions.size(IterableExtensions.<RequiredDelegationConnector>filter(Iterables.<RequiredDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredDelegationConnector.class), _function));
    return (_size == 1);
  }

  public boolean hasRequiredInfrastructureDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<RequiredInfrastructureDelegationConnector, Boolean> _function = (RequiredInfrastructureDelegationConnector dc) -> {
      InfrastructureRequiredRole _innerRequiredRole__RequiredInfrastructureDelegationConnector = dc.getInnerRequiredRole__RequiredInfrastructureDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole__RequiredInfrastructureDelegationConnector, r));
    };
    int _size = IterableExtensions.size(IterableExtensions.<RequiredInfrastructureDelegationConnector>filter(Iterables.<RequiredInfrastructureDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredInfrastructureDelegationConnector.class), _function));
    return (_size == 1);
  }

  public RequiredDelegationConnector getRequiredDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<RequiredDelegationConnector, Boolean> _function = (RequiredDelegationConnector dc) -> {
      OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
    };
    return IterableExtensions.<RequiredDelegationConnector>head(IterableExtensions.<RequiredDelegationConnector>filter(Iterables.<RequiredDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredDelegationConnector.class), _function));
  }

  public RequiredInfrastructureDelegationConnector getRequiredInfrastructureDelegationConnector(final ComposedStructure s, final AssemblyContext ctx, final RequiredRole r) {
    final Function1<RequiredInfrastructureDelegationConnector, Boolean> _function = (RequiredInfrastructureDelegationConnector dc) -> {
      InfrastructureRequiredRole _innerRequiredRole__RequiredInfrastructureDelegationConnector = dc.getInnerRequiredRole__RequiredInfrastructureDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole__RequiredInfrastructureDelegationConnector, r));
    };
    return IterableExtensions.<RequiredInfrastructureDelegationConnector>head(IterableExtensions.<RequiredInfrastructureDelegationConnector>filter(Iterables.<RequiredInfrastructureDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredInfrastructureDelegationConnector.class), _function));
  }

  public boolean hasProvidedInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureProvidedRole p) {
    final Function1<ProvidedDelegationConnector, Boolean> _function = (ProvidedDelegationConnector dc) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
    };
    int _size = IterableExtensions.size(IterableExtensions.<ProvidedDelegationConnector>filter(Iterables.<ProvidedDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), _function));
    return (_size == 1);
  }

  public ProvidedDelegationConnector getProvidedInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureProvidedRole p) {
    final Function1<ProvidedDelegationConnector, Boolean> _function = (ProvidedDelegationConnector dc) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = dc.getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, p));
    };
    return IterableExtensions.<ProvidedDelegationConnector>head(IterableExtensions.<ProvidedDelegationConnector>filter(Iterables.<ProvidedDelegationConnector>filter(s.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), _function));
  }

  public boolean hasRequiredInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureRequiredRole r) {
    final Function1<RequiredDelegationConnector, Boolean> _function = (RequiredDelegationConnector dc) -> {
      OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
    };
    int _size = IterableExtensions.size(IterableExtensions.<RequiredDelegationConnector>filter(Iterables.<RequiredDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredDelegationConnector.class), _function));
    return (_size == 1);
  }

  public RequiredDelegationConnector getRequiredInfrastructureDelegationConnector(final ComposedStructure s, final InfrastructureRequiredRole r) {
    final Function1<RequiredDelegationConnector, Boolean> _function = (RequiredDelegationConnector dc) -> {
      OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = dc.getInnerRequiredRole_RequiredDelegationConnector();
      return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, r));
    };
    return IterableExtensions.<RequiredDelegationConnector>head(IterableExtensions.<RequiredDelegationConnector>filter(Iterables.<RequiredDelegationConnector>filter(s.getConnectors__ComposedStructure(), RequiredDelegationConnector.class), _function));
  }

  public List<EntryLevelSystemCall> querySystemCallsInLoops(final ScenarioBehaviour scenBe) {
    final Function1<Loop, List<EntryLevelSystemCall>> _function = (Loop l) -> {
      return this.querySystemCalls(l.getBodyBehaviour_Loop());
    };
    return IterableExtensions.<EntryLevelSystemCall>toList(Iterables.<EntryLevelSystemCall>concat(IterableExtensions.<Loop, List<EntryLevelSystemCall>>map(Iterables.<Loop>filter(scenBe.getActions_ScenarioBehaviour(), Loop.class), _function)));
  }

  public List<EntryLevelSystemCall> querySystemCallsInBranches(final ScenarioBehaviour scenBe) {
    final Function1<Branch, EList<BranchTransition>> _function = (Branch it) -> {
      return it.getBranchTransitions_Branch();
    };
    final Function1<BranchTransition, List<EntryLevelSystemCall>> _function_1 = (BranchTransition it) -> {
      return this.querySystemCalls(it.getBranchedBehaviour_BranchTransition());
    };
    return IterableExtensions.<EntryLevelSystemCall>toList(Iterables.<EntryLevelSystemCall>concat(IterableExtensions.<BranchTransition, List<EntryLevelSystemCall>>map(Iterables.<BranchTransition>concat(IterableExtensions.<Branch, EList<BranchTransition>>map(Iterables.<Branch>filter(scenBe.getActions_ScenarioBehaviour(), Branch.class), _function)), _function_1)));
  }

  protected List<EntryLevelSystemCall> _querySystemCalls(final ScenarioBehaviour scenBe) {
    ArrayList<EntryLevelSystemCall> _xblockexpression = null;
    {
      final ArrayList<EntryLevelSystemCall> result = new ArrayList<EntryLevelSystemCall>();
      Iterables.<EntryLevelSystemCall>addAll(result, Iterables.<EntryLevelSystemCall>filter(scenBe.getActions_ScenarioBehaviour(), EntryLevelSystemCall.class));
      result.addAll(this.querySystemCallsInLoops(scenBe));
      result.addAll(this.querySystemCallsInBranches(scenBe));
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  public Set<org.palladiosimulator.pcm.system.System> getSystemsFromCalls(final Collection<EntryLevelSystemCall> calls) {
    final Function1<EntryLevelSystemCall, org.palladiosimulator.pcm.system.System> _function = (EntryLevelSystemCall c) -> {
      InterfaceProvidingEntity _providingEntity_ProvidedRole = c.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
      return ((org.palladiosimulator.pcm.system.System) _providingEntity_ProvidedRole);
    };
    return IterableExtensions.<org.palladiosimulator.pcm.system.System>toSet(IterableExtensions.<EntryLevelSystemCall, org.palladiosimulator.pcm.system.System>map(calls, _function));
  }

  protected List<EntryLevelSystemCall> _querySystemCalls(final UsageScenario us) {
    return this.querySystemCalls(us.getScenarioBehaviour_UsageScenario());
  }

  protected String _getID(final VariableReference vr) {
    return vr.getReferenceName();
  }

  protected String _getID(final AbstractNamedReference nsr) {
    return "this is never called";
  }

  protected String _getID(final NamespaceReference nsr) {
    String _referenceName = nsr.getReferenceName();
    String _plus = (_referenceName + ".");
    String _iD = this.getID(nsr.getInnerReference_NamespaceReference());
    return (_plus + _iD);
  }

  public String parameterUsageLHS(final VariableUsage vu) {
    return this.getID(vu.getNamedReference__VariableUsage());
  }

  protected boolean _isInnerReference(final VariableReference vr) {
    String _referenceName = vr.getReferenceName();
    return Objects.equal(_referenceName, "INNER");
  }

  protected boolean _isInnerReference(final AbstractNamedReference nsr) {
    return false;
  }

  protected boolean _isInnerReference(final NamespaceReference nsr) {
    return (Objects.equal(nsr.getReferenceName(), "INNER") || (this.isInnerReference(nsr.getInnerReference_NamespaceReference()) == true));
  }

  protected Set<Entity> _collectRepositories(final org.palladiosimulator.pcm.system.System s) {
    HashSet<Entity> _xblockexpression = null;
    {
      final HashSet<Entity> result = new HashSet<Entity>();
      final Function1<AssemblyContext, Set<Entity>> _function = (AssemblyContext it) -> {
        return this.collectRepositories(it.getEncapsulatedComponent__AssemblyContext());
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(ListExtensions.<AssemblyContext, Set<Entity>>map(s.getAssemblyContexts__ComposedStructure(), _function)));
      final Function1<OperationProvidedRole, Set<Entity>> _function_1 = (OperationProvidedRole it) -> {
        return this.collectRepositories(it);
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(IterableExtensions.<OperationProvidedRole, Set<Entity>>map(Iterables.<OperationProvidedRole>filter(s.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class), _function_1)));
      final Function1<OperationRequiredRole, Set<Entity>> _function_2 = (OperationRequiredRole it) -> {
        return this.collectRepositories(it);
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(IterableExtensions.<OperationRequiredRole, Set<Entity>>map(Iterables.<OperationRequiredRole>filter(s.getRequiredRoles_InterfaceRequiringEntity(), OperationRequiredRole.class), _function_2)));
      final Function1<InfrastructureRequiredRole, Set<Entity>> _function_3 = (InfrastructureRequiredRole it) -> {
        return this.collectRepositories(it);
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(IterableExtensions.<InfrastructureRequiredRole, Set<Entity>>map(Iterables.<InfrastructureRequiredRole>filter(s.getRequiredRoles_InterfaceRequiringEntity(), InfrastructureRequiredRole.class), _function_3)));
      final Function1<InfrastructureProvidedRole, Set<Entity>> _function_4 = (InfrastructureProvidedRole it) -> {
        return this.collectRepositories(it);
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(IterableExtensions.<InfrastructureProvidedRole, Set<Entity>>map(Iterables.<InfrastructureProvidedRole>filter(s.getProvidedRoles_InterfaceProvidingEntity(), InfrastructureProvidedRole.class), _function_4)));
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected Set<Entity> _collectRepositories(final OperationProvidedRole pr) {
    Repository _repository__Interface = pr.getProvidedInterface__OperationProvidedRole().getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }

  protected Set<Entity> _collectRepositories(final InfrastructureProvidedRole pr) {
    Repository _repository__Interface = pr.getProvidedInterface__InfrastructureProvidedRole().getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }

  protected Set<Entity> _collectRepositories(final OperationRequiredRole rr) {
    Repository _repository__Interface = rr.getRequiredInterface__OperationRequiredRole().getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }

  protected Set<Entity> _collectRepositories(final InfrastructureRequiredRole rr) {
    Repository _repository__Interface = rr.getRequiredInterface__InfrastructureRequiredRole().getRepository__Interface();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__Interface));
  }

  protected Set<Entity> _collectRepositories(final RepositoryComponent pct) {
    Repository _repository__RepositoryComponent = pct.getRepository__RepositoryComponent();
    return CollectionLiterals.<Entity>newHashSet(((Entity) _repository__RepositoryComponent));
  }

  protected Set<Entity> _collectRepositories(final CompositeComponent cc) {
    HashSet<Entity> _xblockexpression = null;
    {
      Repository _repository__RepositoryComponent = cc.getRepository__RepositoryComponent();
      final HashSet<Entity> result = CollectionLiterals.<Entity>newHashSet(((Entity) _repository__RepositoryComponent));
      final Function1<AssemblyContext, Set<Entity>> _function = (AssemblyContext it) -> {
        return this.collectRepositories(it.getEncapsulatedComponent__AssemblyContext());
      };
      Iterables.<Entity>addAll(result, 
        Iterables.<Entity>concat(ListExtensions.<AssemblyContext, Set<Entity>>map(cc.getAssemblyContexts__ComposedStructure(), _function)));
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected Set<Entity> _collectRepositories(final InterfaceProvidingRequiringEntity pct) {
    return null;
  }

  public boolean hasSEFF(final Signature service, final RepositoryComponent c) {
    boolean _xifexpression = false;
    if ((c instanceof BasicComponent)) {
      final Function1<ServiceEffectSpecification, Boolean> _function = (ServiceEffectSpecification it) -> {
        Signature _describedService__SEFF = it.getDescribedService__SEFF();
        return Boolean.valueOf(Objects.equal(_describedService__SEFF, service));
      };
      int _size = IterableExtensions.size(IterableExtensions.<ServiceEffectSpecification>filter(((BasicComponent) c).getServiceEffectSpecifications__BasicComponent(), _function));
      _xifexpression = (_size > 0);
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }

  public ServiceEffectSpecification getSEFF(final Signature service, final RepositoryComponent c) {
    final Function1<ServiceEffectSpecification, Boolean> _function = (ServiceEffectSpecification e) -> {
      Signature _describedService__SEFF = e.getDescribedService__SEFF();
      return Boolean.valueOf(Objects.equal(_describedService__SEFF, service));
    };
    return IterableExtensions.<ServiceEffectSpecification>head(IterableExtensions.<ServiceEffectSpecification>filter(((BasicComponent) c).getServiceEffectSpecifications__BasicComponent(), _function));
  }

  public Set<Completion> getAllCompletions(final ComposedStructure s) {
    Set<Completion> _xblockexpression = null;
    {
      final Set<Completion> result = new HashSet<Completion>();
      final Function1<AssemblyContext, RepositoryComponent> _function = (AssemblyContext it) -> {
        return it.getEncapsulatedComponent__AssemblyContext();
      };
      Iterables.<Completion>addAll(result, 
        Iterables.<Completion>filter(ListExtensions.<AssemblyContext, RepositoryComponent>map(s.getAssemblyContexts__ComposedStructure(), _function), Completion.class));
      final Function1<AssemblyContext, RepositoryComponent> _function_1 = (AssemblyContext it) -> {
        return it.getEncapsulatedComponent__AssemblyContext();
      };
      final Function1<ComposedStructure, Boolean> _function_2 = (ComposedStructure comp) -> {
        return Boolean.valueOf(((!Objects.equal(comp, null)) && (!(comp instanceof Completion))));
      };
      final Function1<ComposedStructure, Set<Completion>> _function_3 = (ComposedStructure it) -> {
        return this.getAllCompletions(it);
      };
      Iterables.<Completion>addAll(result, 
        Iterables.<Completion>concat(IterableExtensions.<ComposedStructure, Set<Completion>>map(IterableExtensions.<ComposedStructure>filter(Iterables.<ComposedStructure>filter(ListExtensions.<AssemblyContext, RepositoryComponent>map(s.getAssemblyContexts__ComposedStructure(), _function_1), 
          ComposedStructure.class), _function_2), _function_3)));
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  public AbstractAction findStopAction(final AbstractAction a) {
    AbstractAction _xifexpression = null;
    if ((a instanceof StopAction)) {
      _xifexpression = a;
    } else {
      AbstractAction _xifexpression_1 = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        _xifexpression_1 = this.findStopAction(a.getSuccessor_AbstractAction());
      } else {
        _xifexpression_1 = null;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  public AbstractUserAction findStop(final AbstractUserAction a) {
    AbstractUserAction _xifexpression = null;
    if ((a instanceof Stop)) {
      _xifexpression = a;
    } else {
      AbstractUserAction _xifexpression_1 = null;
      AbstractUserAction _successor = a.getSuccessor();
      boolean _notEquals = (!Objects.equal(_successor, null));
      if (_notEquals) {
        _xifexpression_1 = this.findStop(a.getSuccessor());
      } else {
        _xifexpression_1 = null;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  public List<InterfaceProvidingEntity> getProvidingEntities(final List<ProvidedRole> pr) {
    return this.getProvidingEntitiesRecursive(pr, 0);
  }

  public List<InterfaceProvidingEntity> getProvidingEntitiesRecursive(final List<ProvidedRole> pr, final int i) {
    List<InterfaceProvidingEntity> _xifexpression = null;
    int _size = pr.size();
    boolean _lessThan = (i < _size);
    if (_lessThan) {
      List<InterfaceProvidingEntity> _xifexpression_1 = null;
      boolean _contains = this.getProvidingEntitiesRecursive(pr, (i + 1)).contains(pr.get(i).getProvidingEntity_ProvidedRole());
      if (_contains) {
        _xifexpression_1 = this.getProvidingEntitiesRecursive(pr, (i + 1));
      } else {
        List<InterfaceProvidingEntity> _xblockexpression = null;
        {
          final List<InterfaceProvidingEntity> result = this.getProvidingEntitiesRecursive(pr, (i + 1));
          result.add(pr.get(i).getProvidingEntity_ProvidedRole());
          _xblockexpression = result;
        }
        _xifexpression_1 = _xblockexpression;
      }
      _xifexpression = _xifexpression_1;
    } else {
      _xifexpression = CollectionLiterals.<InterfaceProvidingEntity>emptyList();
    }
    return _xifexpression;
  }

  public BasicComponent findContainerComponent(final EObject o) {
    BasicComponent _xifexpression = null;
    if ((o instanceof BasicComponent)) {
      _xifexpression = ((BasicComponent) o);
    } else {
      _xifexpression = this.findContainerComponent(o.eContainer());
    }
    return _xifexpression;
  }

  public List<org.palladiosimulator.pcm.system.System> uniqueSystemList(final List<org.palladiosimulator.pcm.system.System> s) {
    List<org.palladiosimulator.pcm.system.System> _xifexpression = null;
    boolean _notEquals = (!Objects.equal(s, null));
    if (_notEquals) {
      _xifexpression = this.recursiveList(s, CollectionLiterals.<org.palladiosimulator.pcm.system.System>newArrayList(), 0);
    }
    return _xifexpression;
  }

  private List<org.palladiosimulator.pcm.system.System> recursiveList(final List<org.palladiosimulator.pcm.system.System> s, final List<org.palladiosimulator.pcm.system.System> result, final int pos) {
    List<org.palladiosimulator.pcm.system.System> _xifexpression = null;
    int _size = s.size();
    boolean _lessThan = (pos < _size);
    if (_lessThan) {
      List<org.palladiosimulator.pcm.system.System> _xifexpression_1 = null;
      if (((!Objects.equal(s.get(pos), null)) && result.contains(s.get(pos)))) {
        _xifexpression_1 = this.recursiveList(s, result, (pos + 1));
      } else {
        List<org.palladiosimulator.pcm.system.System> _xblockexpression = null;
        {
          org.palladiosimulator.pcm.system.System _get = s.get(pos);
          final org.palladiosimulator.pcm.system.System element = ((org.palladiosimulator.pcm.system.System) _get);
          boolean _notEquals = (!Objects.equal(element, null));
          if (_notEquals) {
            result.add(element);
          }
          _xblockexpression = this.recursiveList(s, result, (pos + 1));
        }
        _xifexpression_1 = _xblockexpression;
      }
      _xifexpression = _xifexpression_1;
    } else {
      return result;
    }
    return _xifexpression;
  }

  public String getParentSubsystemsIdConcatenationFor(final org.palladiosimulator.pcm.system.System s, final ComposedStructure toMatch) {
    try {
      final String r = this.getParentIdConcatenationFor(s, toMatch);
      boolean _equals = Objects.equal(r, null);
      if (_equals) {
        String _id = s.getId();
        String _plus = ("Could not find parent structure for " + _id);
        throw new Exception(_plus);
      }
      return IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(r.split(" "))));
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  private String _getParentIdConcatenationFor(final RepositoryComponent s, final ComposedStructure toMatch) {
    return "";
  }

  private String _getParentIdConcatenationFor(final org.palladiosimulator.pcm.system.System s, final ComposedStructure toMatch) {
    return this.getSystemParentIdConcatenationFor(s, toMatch);
  }

  private String _getParentIdConcatenationFor(final SubSystem s, final ComposedStructure toMatch) {
    return this.getSystemParentIdConcatenationFor(s, toMatch);
  }

  private String _getParentIdConcatenationFor(final Completion c, final ComposedStructure toMatch) {
    return this.getSystemParentIdConcatenationFor(c, toMatch);
  }

  private String getSystemParentIdConcatenationFor(final ComposedStructure s, final ComposedStructure toMatch) {
    final Function1<AssemblyContext, String> _function = (AssemblyContext ac) -> {
      String _matchID = this.matchID(ac.getEncapsulatedComponent__AssemblyContext(), toMatch);
      String _id = ac.getId();
      return (_matchID + _id);
    };
    final Function1<String, Boolean> _function_1 = (String s2) -> {
      return Boolean.valueOf(s2.contains(toMatch.getId()));
    };
    return IterableExtensions.<String>findFirst(ListExtensions.<AssemblyContext, String>map(s.getAssemblyContexts__ComposedStructure(), _function), _function_1);
  }

  private String matchID(final RepositoryComponent s, final ComposedStructure toMatch) {
    String _xifexpression = null;
    boolean _contains = s.getId().contains(toMatch.getId());
    if (_contains) {
      String _id = toMatch.getId();
      _xifexpression = (_id + " ");
    } else {
      _xifexpression = this.getParentIdConcatenationFor(s, toMatch);
    }
    return _xifexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final AbstractAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      _xifexpression = this.queryExternalCallActions(a.getSuccessor_AbstractAction(), result);
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final ExternalCallAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        result.add(a);
        _xblockexpression = this.queryExternalCallActions(a.getSuccessor_AbstractAction(), result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final BranchAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      this.queryExternalCallActions(a.getBranches_Branch(), result);
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        _xifexpression = this.queryExternalCallActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final List<AbstractBranchTransition> list, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        this.queryExternalCallActions(this.findStart(IterableExtensions.<AbstractBranchTransition>head(list).getBranchBehaviour_BranchTransition().getSteps_Behaviour()), result);
        _xblockexpression = this.queryExternalCallActions(IterableExtensions.<AbstractBranchTransition>toList(IterableExtensions.<AbstractBranchTransition>tail(list)), result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final AbstractLoopAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      this.queryExternalCallActions(this.findStart(a.getBodyBehaviour_Loop().getSteps_Behaviour()), result);
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        _xifexpression = this.queryExternalCallActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final ForkAction a, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xblockexpression = null;
    {
      this.queryExternalCallActionsForkedBehaviour(a.getAsynchronousForkedBehaviours_ForkAction(), result);
      SynchronisationPoint _synchronisingBehaviours_ForkAction = a.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        this.queryExternalCallActions(a.getSynchronisingBehaviours_ForkAction(), result);
      }
      List<ExternalCallAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals_1 = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals_1) {
        _xifexpression = this.queryExternalCallActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final SynchronisationPoint p, final List<ExternalCallAction> result) {
    return this.queryExternalCallActionsForkedBehaviour(p.getSynchronousForkedBehaviours_SynchronisationPoint(), result);
  }

  public List<ExternalCallAction> queryExternalCallActionsForkedBehaviour(final List<ForkedBehaviour> list, final List<ExternalCallAction> result) {
    List<ExternalCallAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<ExternalCallAction> _xblockexpression = null;
      {
        this.queryExternalCallActions(IterableExtensions.<ForkedBehaviour>head(list), result);
        _xblockexpression = this.queryExternalCallActionsForkedBehaviour(IterableExtensions.<ForkedBehaviour>toList(IterableExtensions.<ForkedBehaviour>tail(list)), result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<ExternalCallAction> _queryExternalCallActions(final ForkedBehaviour b, final List<ExternalCallAction> result) {
    return this.queryExternalCallActions(this.findStart(b.getSteps_Behaviour()), result);
  }

  protected List<InternalAction> _queryInternalActions(final AbstractAction a, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      _xifexpression = this.queryInternalActions(a.getSuccessor_AbstractAction(), result);
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<InternalAction> _queryInternalActions(final InternalAction a, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
    boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
    if (_notEquals) {
      List<InternalAction> _xblockexpression = null;
      {
        final ArrayList<InternalAction> newResult = CollectionLiterals.<InternalAction>newArrayList(a);
        newResult.addAll(result);
        _xblockexpression = this.queryInternalActions(a.getSuccessor_AbstractAction(), newResult);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<InternalAction> _queryInternalActions(final BranchAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      this.queryInternalActions(a.getBranches_Branch(), result);
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        _xifexpression = this.queryInternalActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<InternalAction> _queryInternalActions(final List<AbstractBranchTransition> list, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<InternalAction> _xblockexpression = null;
      {
        this.queryInternalActions(this.findStart(IterableExtensions.<AbstractBranchTransition>head(list).getBranchBehaviour_BranchTransition().getSteps_Behaviour()), result);
        _xblockexpression = this.queryInternalActions(IterableExtensions.<AbstractBranchTransition>toList(IterableExtensions.<AbstractBranchTransition>tail(list)), result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<InternalAction> _queryInternalActions(final AbstractLoopAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      this.queryInternalActions(this.findStart(a.getBodyBehaviour_Loop().getSteps_Behaviour()), result);
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals) {
        _xifexpression = this.queryInternalActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<InternalAction> _queryInternalActions(final ForkAction a, final List<InternalAction> result) {
    List<InternalAction> _xblockexpression = null;
    {
      this.queryInternalActionsForkedBehaviour(a.getAsynchronousForkedBehaviours_ForkAction(), result);
      SynchronisationPoint _synchronisingBehaviours_ForkAction = a.getSynchronisingBehaviours_ForkAction();
      boolean _notEquals = (!Objects.equal(_synchronisingBehaviours_ForkAction, null));
      if (_notEquals) {
        this.queryInternalActions(a.getSynchronisingBehaviours_ForkAction(), result);
      }
      List<InternalAction> _xifexpression = null;
      AbstractAction _successor_AbstractAction = a.getSuccessor_AbstractAction();
      boolean _notEquals_1 = (!Objects.equal(_successor_AbstractAction, null));
      if (_notEquals_1) {
        _xifexpression = this.queryInternalActions(a.getSuccessor_AbstractAction(), result);
      } else {
        _xifexpression = result;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  protected List<InternalAction> _queryInternalActions(final SynchronisationPoint p, final List<InternalAction> result) {
    return this.queryInternalActionsForkedBehaviour(p.getSynchronousForkedBehaviours_SynchronisationPoint(), result);
  }

  public List<InternalAction> queryInternalActionsForkedBehaviour(final List<ForkedBehaviour> list, final List<InternalAction> result) {
    List<InternalAction> _xifexpression = null;
    int _size = list.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      List<InternalAction> _xblockexpression = null;
      {
        this.queryInternalActions(IterableExtensions.<ForkedBehaviour>head(list), result);
        _xblockexpression = this.queryInternalActionsForkedBehaviour(IterableExtensions.<ForkedBehaviour>toList(IterableExtensions.<ForkedBehaviour>tail(list)), result);
      }
      _xifexpression = _xblockexpression;
    } else {
      _xifexpression = result;
    }
    return _xifexpression;
  }

  protected List<InternalAction> _queryInternalActions(final ForkedBehaviour b, final List<InternalAction> result) {
    return this.queryInternalActions(this.findStart(b.getSteps_Behaviour()), result);
  }

  public ResourceDemandingSEFF getRdseff(final AbstractAction action) {
    return Helper.getRdseff(action);
  }

  public boolean test(final Connector c, final AssemblyContext ctx, final Role r) {
    if (c instanceof AssemblyEventConnector
         && r instanceof SinkRole) {
      return _test((AssemblyEventConnector)c, ctx, (SinkRole)r);
    } else if (c instanceof AssemblyInfrastructureConnector
         && r instanceof InfrastructureRequiredRole) {
      return _test((AssemblyInfrastructureConnector)c, ctx, (InfrastructureRequiredRole)r);
    } else if (c instanceof AssemblyConnector
         && r instanceof RequiredRole) {
      return _test((AssemblyConnector)c, ctx, (RequiredRole)r);
    } else if (c != null
         && r instanceof RequiredRole) {
      return _test(c, ctx, (RequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c, ctx, r).toString());
    }
  }

  public List<EntryLevelSystemCall> querySystemCalls(final Entity scenBe) {
    if (scenBe instanceof ScenarioBehaviour) {
      return _querySystemCalls((ScenarioBehaviour)scenBe);
    } else if (scenBe instanceof UsageScenario) {
      return _querySystemCalls((UsageScenario)scenBe);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(scenBe).toString());
    }
  }

  public String getID(final AbstractNamedReference nsr) {
    if (nsr instanceof NamespaceReference) {
      return _getID((NamespaceReference)nsr);
    } else if (nsr instanceof VariableReference) {
      return _getID((VariableReference)nsr);
    } else if (nsr != null) {
      return _getID(nsr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(nsr).toString());
    }
  }

  public boolean isInnerReference(final AbstractNamedReference nsr) {
    if (nsr instanceof NamespaceReference) {
      return _isInnerReference((NamespaceReference)nsr);
    } else if (nsr instanceof VariableReference) {
      return _isInnerReference((VariableReference)nsr);
    } else if (nsr != null) {
      return _isInnerReference(nsr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(nsr).toString());
    }
  }

  public Set<Entity> collectRepositories(final CDOObject cc) {
    if (cc instanceof CompositeComponent) {
      return _collectRepositories((CompositeComponent)cc);
    } else if (cc instanceof org.palladiosimulator.pcm.system.System) {
      return _collectRepositories((org.palladiosimulator.pcm.system.System)cc);
    } else if (cc instanceof RepositoryComponent) {
      return _collectRepositories((RepositoryComponent)cc);
    } else if (cc instanceof InterfaceProvidingRequiringEntity) {
      return _collectRepositories((InterfaceProvidingRequiringEntity)cc);
    } else if (cc instanceof InfrastructureProvidedRole) {
      return _collectRepositories((InfrastructureProvidedRole)cc);
    } else if (cc instanceof InfrastructureRequiredRole) {
      return _collectRepositories((InfrastructureRequiredRole)cc);
    } else if (cc instanceof OperationProvidedRole) {
      return _collectRepositories((OperationProvidedRole)cc);
    } else if (cc instanceof OperationRequiredRole) {
      return _collectRepositories((OperationRequiredRole)cc);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(cc).toString());
    }
  }

  private String getParentIdConcatenationFor(final InterfaceProvidingRequiringEntity c, final ComposedStructure toMatch) {
    if (c instanceof Completion) {
      return _getParentIdConcatenationFor((Completion)c, toMatch);
    } else if (c instanceof SubSystem) {
      return _getParentIdConcatenationFor((SubSystem)c, toMatch);
    } else if (c instanceof org.palladiosimulator.pcm.system.System) {
      return _getParentIdConcatenationFor((org.palladiosimulator.pcm.system.System)c, toMatch);
    } else if (c instanceof RepositoryComponent) {
      return _getParentIdConcatenationFor((RepositoryComponent)c, toMatch);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c, toMatch).toString());
    }
  }

  public List<ExternalCallAction> queryExternalCallActions(final Object a, final List<ExternalCallAction> result) {
    if (a instanceof AbstractLoopAction) {
      return _queryExternalCallActions((AbstractLoopAction)a, result);
    } else if (a instanceof BranchAction) {
      return _queryExternalCallActions((BranchAction)a, result);
    } else if (a instanceof ExternalCallAction) {
      return _queryExternalCallActions((ExternalCallAction)a, result);
    } else if (a instanceof ForkAction) {
      return _queryExternalCallActions((ForkAction)a, result);
    } else if (a instanceof AbstractAction) {
      return _queryExternalCallActions((AbstractAction)a, result);
    } else if (a instanceof ForkedBehaviour) {
      return _queryExternalCallActions((ForkedBehaviour)a, result);
    } else if (a instanceof SynchronisationPoint) {
      return _queryExternalCallActions((SynchronisationPoint)a, result);
    } else if (a instanceof List) {
      return _queryExternalCallActions((List<AbstractBranchTransition>)a, result);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(a, result).toString());
    }
  }

  public List<InternalAction> queryInternalActions(final Object a, final List<InternalAction> result) {
    if (a instanceof AbstractLoopAction) {
      return _queryInternalActions((AbstractLoopAction)a, result);
    } else if (a instanceof BranchAction) {
      return _queryInternalActions((BranchAction)a, result);
    } else if (a instanceof ForkAction) {
      return _queryInternalActions((ForkAction)a, result);
    } else if (a instanceof InternalAction) {
      return _queryInternalActions((InternalAction)a, result);
    } else if (a instanceof AbstractAction) {
      return _queryInternalActions((AbstractAction)a, result);
    } else if (a instanceof ForkedBehaviour) {
      return _queryInternalActions((ForkedBehaviour)a, result);
    } else if (a instanceof SynchronisationPoint) {
      return _queryInternalActions((SynchronisationPoint)a, result);
    } else if (a instanceof List) {
      return _queryInternalActions((List<AbstractBranchTransition>)a, result);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(a, result).toString());
    }
  }
}
