/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.impl;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.SizeTooSmallException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityDensityFunctionImpl;
import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;

public class SamplePDFImpl
extends ProbabilityDensityFunctionImpl
implements ISamplePDF {
    private static final Complex DEFAULT_FILL_VALUE = Complex.ZERO;
    private static final int FOURIER_TRANSFORM = 0;
    private static final int INVERSE_FOURIER_TRANSFORM = 1;
    private double distance;
    private List<Complex> values;
    private Complex fillValue;
    private FastFourierTransformer fft = new FastFourierTransformer();

    protected SamplePDFImpl(double distance, IUnit unit, IRandomGenerator generator) {
        this(distance, unit, false, generator);
    }

    protected SamplePDFImpl(double distance, IUnit unit, boolean isInFrequencyDomain, IRandomGenerator generator) {
        super(unit, isInFrequencyDomain);
        this.distance = distance;
        this.values = new ArrayList<Complex>();
        this.fillValue = DEFAULT_FILL_VALUE;
        this.randomGenerator = generator;
    }

    @Override
    public IProbabilityDensityFunction add(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException, FunctionsInDifferenDomainsException, IncompatibleUnitsException {
        return SamplePDFImpl.performOperation(Operation.ADD, this, pdf);
    }

    @Override
    public IProbabilityDensityFunction mult(IProbabilityDensityFunction pdf) throws UnknownPDFTypeException, FunctionsInDifferenDomainsException, IncompatibleUnitsException {
        return SamplePDFImpl.performOperation(Operation.MULT, this, pdf);
    }

    @Override
    public IProbabilityDensityFunction div(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        return SamplePDFImpl.performOperation(Operation.DIV, this, pdf);
    }

    @Override
    public IProbabilityDensityFunction sub(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        return SamplePDFImpl.performOperation(Operation.SUB, this, pdf);
    }

    @Override
    public IProbabilityDensityFunction scale(double scalar) {
        ArrayList<Complex> resultList = new ArrayList<Complex>();
        for (Complex z : this.values) {
            resultList.add(z.multiply(scalar));
        }
        return pfFactory.createSamplePDFFromComplex(this.distance, resultList, this.isInFrequencyDomain(), pfFactory.createDefaultUnit());
    }

    @Override
    public IProbabilityDensityFunction getFourierTransform() {
        return this.transformFunction(0);
    }

    @Override
    public IProbabilityDensityFunction getInverseFourierTransform() {
        return this.transformFunction(1);
    }

    @Override
    public void expand(int newSize) throws SizeTooSmallException {
        int diff = newSize - this.values.size();
        if (diff < 0) {
            throw new SizeTooSmallException();
        }
        int i = 0;
        while (i < diff) {
            this.values.add(new Complex(this.fillValue.getReal(), this.fillValue.getImaginary()));
            ++i;
        }
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public List<Double> getValuesAsDouble() {
        return MathTools.transformComplexToDouble(this.values);
    }

    @Override
    public void setValuesAsDouble(List<Double> values) {
        this.values = new ArrayList<Complex>(MathTools.transformDoubleToComplex(values));
    }

    @Override
    public double getFillValueAsDouble() {
        return this.fillValue.getReal();
    }

    @Override
    public void setFillValue(double fillValue) {
        this.fillValue = new Complex(fillValue, 0.0);
    }

    @Override
    public Complex getFillValue() {
        return this.fillValue;
    }

    @Override
    public ISamplePDF getFunctionWithNewDistance(double distance) throws NegativeDistanceException, FunctionNotInTimeDomainException {
        List<Double> newList = this.getValuesForDistance(distance);
        return pfFactory.createSamplePDFFromDouble(distance, newList, this.getUnit());
    }

    @Override
    public List<Complex> getValues() {
        return new ArrayList<Complex>(this.values);
    }

    @Override
    public void setFillValue(Complex fillValue) {
        this.fillValue = fillValue;
    }

    @Override
    public void setValues(List<Complex> values, boolean isInFrequencyDomain) {
        this.values = new ArrayList<Complex>(values);
        this.setInFrequencyDomain(isInFrequencyDomain);
    }

    @Override
    public double getLowerDomainBorder() {
        return 0.0;
    }

    @Override
    public double drawSample() {
        double result = 0.0;
        List<Double> intervals = MathTools.computeCumulativeProbabilities(this.getValuesAsDouble());
        double probability = this.randomGenerator.random();
        int currentInterval = 0;
        while (currentInterval < intervals.size()) {
            double upperBoundProbability = intervals.get(currentInterval);
            if (probability < upperBoundProbability) {
                double middleValue = this.distance * (double)currentInterval;
                double lowerBoundValue = middleValue - this.distance / 2.0;
                double lowerBoundProbability = currentInterval == 0 ? 0.0 : intervals.get(currentInterval - 1);
                double probabilityDistance = upperBoundProbability - lowerBoundProbability;
                double scalingFactor = probabilityDistance > 0.0 ? (probability - lowerBoundProbability) / probabilityDistance : 0.0;
                result = lowerBoundValue + this.distance * scalingFactor;
                break;
            }
            ++currentInterval;
        }
        return result;
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException, FunctionNotInTimeDomainException {
        if (!this.isInTimeDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        double pos = 0.0;
        double mean = 0.0;
        for (Complex val : this.values) {
            mean += pos * val.getReal();
            pos += this.distance;
        }
        return mean;
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        return this.getPercentile(50);
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        if (!this.hasOrderedDomain()) {
            throw new UnorderedDomainException();
        }
        if (p < 0 || p > 100) {
            throw new IndexOutOfBoundsException();
        }
        double prob = (double)p / 100.0;
        double currProb = 0.0;
        int i = 0;
        while (i < this.values.size() && currProb < prob) {
            currProb += this.values.get(i).getReal();
            ++i;
        }
        return (double)i * this.distance;
    }

    @Override
    public int numberOfSamples() {
        return this.values.size();
    }

    public boolean equals(Object obj) {
        ISamplePDF pdf;
        boolean result = false;
        if (obj instanceof ISamplePDF && (pdf = (ISamplePDF)obj).getDistance() == this.getDistance()) {
            List<Complex> v1 = this.values;
            List<Complex> v2 = pdf.getValues();
            if (v1.size() > v2.size()) {
                List<Complex> tmp = v2;
                v2 = v1;
                v1 = tmp;
            }
            Iterator<Complex> iter = v2.iterator();
            result = true;
            for (Complex z : v1) {
                if (MathTools.equalsComplex(iter.next(), z)) continue;
                result = false;
                break;
            }
            while (iter.hasNext() && result) {
                if (MathTools.equalsComplex(iter.next(), new Complex(0.0, 0.0))) continue;
                result = false;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String result = "unit = " + this.getUnit().getUnitName() + "; ";
        result = String.valueOf(result) + "distance = " + this.getDistance() + "; ";
        result = String.valueOf(result) + "samples: ";
        boolean isFirst = true;
        for (Complex z : this.values) {
            if (isFirst) {
                isFirst = false;
            } else {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "(" + MathTools.asString(z.getReal()) + ", " + MathTools.asString(z.getImaginary()) + ")";
        }
        return result;
    }

    private List<Double> getValuesForDistance(double newDistance) throws NegativeDistanceException, FunctionNotInTimeDomainException {
        if (MathTools.equalsDouble(this.distance, newDistance)) {
            return this.getValuesAsDouble();
        }
        if (this.distance < 0.0 || newDistance < 0.0) {
            throw new NegativeDistanceException();
        }
        if (!this.isInTimeDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        double oldPoint = this.distance / 2.0;
        double newPoint = newDistance / 2.0;
        int currentIndex = 0;
        double buffer = 0.0;
        ArrayList<Double> newValues = new ArrayList();
        if (MathTools.equalsDouble(newDistance, this.distance)) {
            newValues = this.getValuesAsDouble();
        } else if (newDistance < this.distance) {
            while (currentIndex < this.values.size()) {
                if (newPoint < oldPoint) {
                    if (newPoint == newDistance / 2.0) {
                        newValues.add(this.getProb(currentIndex, newPoint, oldPoint));
                    } else {
                        newValues.add(this.getProb(currentIndex, newDistance, this.distance));
                    }
                } else {
                    if (oldPoint == this.distance / 2.0) {
                        newValues.add(this.getLeftProb(oldPoint, currentIndex, newPoint, newDistance, oldPoint) + this.getRightProb(oldPoint, currentIndex + 1, newPoint));
                    } else {
                        newValues.add(this.getLeftProb(oldPoint, currentIndex, newPoint, newDistance, this.distance) + this.getRightProb(oldPoint, currentIndex + 1, newPoint));
                    }
                    oldPoint += this.distance;
                    ++currentIndex;
                }
                newPoint += newDistance;
            }
        } else if (newDistance > this.distance) {
            while (currentIndex < this.values.size()) {
                if (oldPoint < newPoint) {
                    buffer += this.values.get(currentIndex).getReal();
                } else {
                    newValues.add(buffer + this.getLeftProb(newPoint, currentIndex, oldPoint, this.distance, this.distance));
                    buffer = this.getRightProb(newPoint, currentIndex, oldPoint);
                    newPoint += newDistance;
                }
                oldPoint += this.distance;
                ++currentIndex;
            }
            if (buffer != 0.0) {
                newValues.add(buffer);
            }
        }
        return newValues;
    }

    private double getProb(int index, double newDistance, double distance) {
        return newDistance / distance * this.values.get(index).getReal();
    }

    private double getLeftProb(double oldP, int index, double newP, double diff, double distance) {
        double fractal = (diff - (newP - oldP)) / distance;
        return this.values.get(index).getReal() * fractal;
    }

    private double getRightProb(double oldP, int index, double newP) {
        double fractal = (newP - oldP) / this.distance;
        if (index < this.values.size()) {
            return this.values.get(index).getReal() * fractal;
        }
        return 0.0;
    }

    private static IProbabilityDensityFunction performOperation(Operation op, IProbabilityDensityFunction pdf1, IProbabilityDensityFunction pdf2) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        List<ISamplePDF> operands = SamplePDFImpl.prepareForComputation(pdf1, pdf2);
        ISamplePDF sPDF1 = operands.get(0);
        ISamplePDF sPDF2 = operands.get(1);
        ArrayList<Complex> resultList = new ArrayList<Complex>();
        double distance = sPDF1.getDistance();
        boolean inFrequencyDomain = sPDF1.isInFrequencyDomain();
        Iterator<Complex> iterator = sPDF2.getValues().iterator();
        for (Complex z1 : sPDF1.getValues()) {
            Complex z2 = iterator.next();
            resultList.add(switch (op) {
                case Operation.ADD -> z1.add(z2);
                case Operation.SUB -> z1.subtract(z2);
                case Operation.MULT -> z1.multiply(z2);
                case Operation.DIV -> z1.divide(z2);
                default -> null;
            });
        }
        ISamplePDF p = pfFactory.createSamplePDFFromComplex(distance, resultList, inFrequencyDomain, sPDF1.getUnit());
        return p;
    }

    private static List<ISamplePDF> prepareForComputation(IProbabilityDensityFunction pdf1, IProbabilityDensityFunction pdf2) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        if (pdf1.isInTimeDomain() != pdf2.isInTimeDomain()) {
            throw new FunctionsInDifferenDomainsException();
        }
        if (pdf1.getUnit() != null && !pdf1.getUnit().equals(pdf2.getUnit())) {
            throw new IncompatibleUnitsException();
        }
        ISamplePDF sPDF1 = pfFactory.transformToSamplePDF(pdf1);
        ISamplePDF sPDF2 = pfFactory.transformToSamplePDF(pdf2);
        List<ISamplePDF> operands = SamplePDFImpl.createFunctionsWithEqualDistance(sPDF1, sPDF2);
        sPDF1 = operands.get(0);
        sPDF2 = operands.get(1);
        try {
            int maxSize = Math.max(sPDF1.numberOfSamples(), sPDF2.numberOfSamples());
            sPDF1.expand(maxSize);
            sPDF2.expand(maxSize);
        }
        catch (SizeTooSmallException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return operands;
    }

    private IProbabilityDensityFunction transformFunction(int flag) {
        Complex[] cValues = new Complex[MathTools.nextPowerOfTwo(this.values.size())];
        this.values.toArray(cValues);
        int i = this.values.size();
        while (i < cValues.length) {
            cValues[i] = Complex.ZERO;
            ++i;
        }
        Complex[] transformedData = flag == 0 ? this.fft.transform(cValues) : this.fft.inversetransform(cValues);
        List<Complex> resultList = Arrays.asList(transformedData);
        ISamplePDF spdf = pfFactory.createSamplePDFFromComplex(this.distance, resultList, !this.isInFrequencyDomain(), pfFactory.createDefaultUnit());
        return spdf;
    }

    protected static List<ISamplePDF> createFunctionsWithEqualDistance(ISamplePDF pdf1, ISamplePDF pdf2) {
        ArrayList<ISamplePDF> resultList = new ArrayList<ISamplePDF>();
        try {
            if (!MathTools.equalsDouble(pdf1.getDistance(), pdf2.getDistance())) {
                boolean inTimeDomain = pdf1.isInTimeDomain();
                if (!inTimeDomain) {
                    pdf1 = (ISamplePDF)pdf1.getInverseFourierTransform();
                    pdf2 = (ISamplePDF)pdf2.getInverseFourierTransform();
                }
                double distance = MathTools.gcd(pdf1.getDistance(), pdf2.getDistance());
                pdf1 = pdf1.getFunctionWithNewDistance(distance);
                pdf2 = pdf2.getFunctionWithNewDistance(distance);
                if (!inTimeDomain) {
                    pdf1 = (ISamplePDF)pdf1.getFourierTransform();
                    pdf2 = (ISamplePDF)pdf2.getFourierTransform();
                }
            }
            resultList.add(pdf1);
            resultList.add(pdf2);
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return resultList;
    }

    @Override
    public double getProbabilitySum() throws FunctionNotInTimeDomainException {
        if (!this.isInTimeDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        double sum = 0.0;
        for (Complex value : this.values) {
            sum += value.getReal();
        }
        return sum;
    }

    @Override
    public void checkConstrains() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        if (this.distance <= 0.0) {
            throw new NegativeDistanceException();
        }
        if (this.getUnit() == null) {
            throw new UnitNotSetException();
        }
        if (this.getUnit().getUnitName() == null) {
            throw new UnitNameNotSetException();
        }
        if (!MathTools.equalsDouble(this.getProbabilitySum(), 1.0)) {
            throw new ProbabilitySumNotOneException();
        }
        for (double p : this.getValuesAsDouble()) {
            if (p >= -1.0E-5 && p <= 1.00001) continue;
            throw new InvalidSampleValueException();
        }
    }

    @Override
    public IProbabilityDensityFunction getCumulativeFunction() throws FunctionNotInTimeDomainException {
        if (!this.isInTimeDomain()) {
            throw new FunctionNotInTimeDomainException();
        }
        List<Double> cumulativeProbabilities = MathTools.computeCumulativeProbabilities(this.getValuesAsDouble());
        ISamplePDF spdf = pfFactory.createSamplePDFFromDouble(this.distance, cumulativeProbabilities, this.isInFrequencyDomain(), this.getUnit(), this.getRandomGenerator());
        spdf.setFillValue(new Complex(1.0, 0.0));
        return spdf;
    }

    @Override
    public double probabilisticEquals(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        return this.compareTo(pdf, ProbabilityDensityFunctionImpl.CompareOperation.EQUALS);
    }

    @Override
    public double greaterThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        return this.compareTo(pdf, ProbabilityDensityFunctionImpl.CompareOperation.GREATER);
    }

    @Override
    public double lessThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        return this.compareTo(pdf, ProbabilityDensityFunctionImpl.CompareOperation.LESS);
    }

    private double compareTo(IProbabilityDensityFunction pdf, ProbabilityDensityFunctionImpl.CompareOperation op) throws ProbabilityFunctionException {
        ISamplePDF sPDF = pfFactory.transformToSamplePDF(pdf);
        sPDF = sPDF.getFunctionWithNewDistance(this.distance);
        int maxSize = Math.max(sPDF.getValues().size(), this.getValues().size());
        sPDF.expand(maxSize);
        this.expand(maxSize);
        List<Double> pdfValues = sPDF.getValuesAsDouble();
        List<Double> thisValues = this.getValuesAsDouble();
        switch (op) {
            case EQUALS: {
                return this.equals(thisValues, pdfValues);
            }
            case GREATER: {
                return this.greaterThan(thisValues, pdfValues);
            }
            case LESS: {
                return this.greaterThan(pdfValues, thisValues);
            }
        }
        return 0.0;
    }

    private double greaterThan(List<Double> firstValues, List<Double> secondValues) {
        assert (firstValues.size() == secondValues.size());
        double prob = 0.0;
        int i = 0;
        while (i < secondValues.size()) {
            double tempProb = this.greaterThan(secondValues, i);
            prob += tempProb * secondValues.get(i);
            ++i;
        }
        return prob;
    }

    private double greaterThan(List<Double> secondValues, int i) {
        double prob = 0.0;
        int j = i + 1;
        while (j < secondValues.size()) {
            prob += secondValues.get(j).doubleValue();
            ++j;
        }
        return prob;
    }

    private double equals(List<Double> firstValues, List<Double> secondValues) {
        double prob = 0.0;
        int i = 0;
        while (i < firstValues.size()) {
            prob += firstValues.get(i) * secondValues.get(i);
            ++i;
        }
        return prob;
    }

    @Override
    public IProbabilityDensityFunction stretchDomain(double scalar) {
        SamplePDFImpl sPDF = new SamplePDFImpl(this.getDistance() * scalar, this.getUnit(), this.randomGenerator);
        sPDF.setValues(this.getValues(), this.isInFrequencyDomain());
        sPDF.setFillValue(this.getFillValue());
        return sPDF;
    }

    @Override
    public IProbabilityDensityFunction shiftDomain(double scalar) throws DomainNotNumbersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Complex getValue(int pos) {
        return pos < this.values.size() ? this.values.get(pos) : this.fillValue;
    }

    @Override
    public Double getValueAsDouble(int pos) {
        return this.getValue(pos).getReal();
    }

    private static enum Operation {
        ADD,
        SUB,
        MULT,
        DIV;

    }
}

