/*
 * Decompiled with CFR 0.152.
 */
package scheduler.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PassiveResourceType implements Enumerator
{
    FAIR(0, "FAIR", "FAIR"),
    UNFAIR(1, "UNFAIR", "UNFAIR");

    public static final int FAIR_VALUE = 0;
    public static final int UNFAIR_VALUE = 1;
    private static final PassiveResourceType[] VALUES_ARRAY;
    public static final List<PassiveResourceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PassiveResourceType[]{FAIR, UNFAIR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PassiveResourceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PassiveResourceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PassiveResourceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PassiveResourceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PassiveResourceType get(int value) {
        switch (value) {
            case 0: {
                return FAIR;
            }
            case 1: {
                return UNFAIR;
            }
        }
        return null;
    }

    private PassiveResourceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

