/*
 * Decompiled with CFR 0.152.
 */
package scheduler.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoadBalancingType implements Enumerator
{
    IDLE_TO_ONE(0, "IDLE_TO_ONE", "IDLE_TO_ONE"),
    IDLE_TO_THRESHOLD(1, "IDLE_TO_THRESHOLD", "IDLE_TO_THRESHOLD"),
    ANY_TO_THRESHOLD(2, "ANY_TO_THRESHOLD", "ANY_TO_THRESHOLD");

    public static final int IDLE_TO_ONE_VALUE = 0;
    public static final int IDLE_TO_THRESHOLD_VALUE = 1;
    public static final int ANY_TO_THRESHOLD_VALUE = 2;
    private static final LoadBalancingType[] VALUES_ARRAY;
    public static final List<LoadBalancingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoadBalancingType[]{IDLE_TO_ONE, IDLE_TO_THRESHOLD, ANY_TO_THRESHOLD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoadBalancingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoadBalancingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoadBalancingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoadBalancingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoadBalancingType get(int value) {
        switch (value) {
            case 0: {
                return IDLE_TO_ONE;
            }
            case 1: {
                return IDLE_TO_THRESHOLD;
            }
            case 2: {
                return ANY_TO_THRESHOLD;
            }
        }
        return null;
    }

    private LoadBalancingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

