/*
 * Decompiled with CFR 0.152.
 */
package scheduler.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PreferredPriority implements Enumerator
{
    HIGHER(0, "HIGHER", "HIGHER"),
    LOWER(1, "LOWER", "LOWER");

    public static final int HIGHER_VALUE = 0;
    public static final int LOWER_VALUE = 1;
    private static final PreferredPriority[] VALUES_ARRAY;
    public static final List<PreferredPriority> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PreferredPriority[]{HIGHER, LOWER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PreferredPriority get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PreferredPriority result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PreferredPriority getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PreferredPriority result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PreferredPriority get(int value) {
        switch (value) {
            case 0: {
                return HIGHER;
            }
            case 1: {
                return LOWER;
            }
        }
        return null;
    }

    private PreferredPriority(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

