/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.AbstractSimResource;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractActiveResource
extends AbstractSimResource
implements IActiveResource {
    private final List<IActiveResourceStateSensor> observers = new ArrayList<IActiveResourceStateSensor>();
    private final IResourceTableManager resourceTableManager;

    public AbstractActiveResource(SchedulerModel model, long capacity, String name, String id, IResourceTableManager resourceTableManager) {
        super(model, capacity, name, id);
        this.resourceTableManager = resourceTableManager;
    }

    protected abstract void doProcessing(ISchedulableProcess var1, int var2, double var3);

    protected abstract void enqueue(ISchedulableProcess var1);

    protected abstract void dequeue(ISchedulableProcess var1);

    @Override
    public final void process(ISchedulableProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        if (!this.getModel().getSimulationControl().isRunning()) {
            return;
        }
        AbstractActiveResource last = this.resourceTableManager.getLastResource(process);
        if (!this.equals(last)) {
            if (last != null) {
                last.dequeue(process);
            }
            this.enqueue(process);
            this.resourceTableManager.setLastResource(process, this);
        }
        if (parameterMap != null && parameterMap.isEmpty()) {
            this.doProcessing(process, resourceServiceID, demand);
        } else {
            this.doProcessing(process, resourceServiceID, parameterMap, demand);
        }
    }

    protected void doProcessing(ISchedulableProcess process, int resourceServiceID, Map<String, Serializable> parameterMap, double demand) {
        throw new RuntimeException("doProcessing has to be overwritten to allow additional Parameters for active Resources");
    }

    @Override
    public void notifyTerminated(ISchedulableProcess simProcess) {
        this.resourceTableManager.notifyTerminated(simProcess);
    }

    @Override
    public void addObserver(IActiveResourceStateSensor observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(IActiveResourceStateSensor observer) {
        this.observers.remove(observer);
    }

    protected void fireStateChange(long state, int instanceId) {
        for (IActiveResourceStateSensor l : this.observers) {
            l.update(state, instanceId);
        }
    }

    protected void fireDemandCompleted(ISchedulableProcess simProcess) {
        for (IActiveResourceStateSensor l : this.observers) {
            l.demandCompleted(simProcess);
        }
    }
}

