/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active.special;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEventDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.NullEntity;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SimProcessorSharingResourceLinuxO1
extends AbstractActiveResource {
    private static final Logger LOGGER = Logger.getLogger(SimProcessorSharingResourceLinuxO1.class);
    private final ProcessingFinishedEvent processingFinished = new ProcessingFinishedEvent(null);
    private final ArrayList<Hashtable<ISchedulableProcess, Double>> running_processesPerCore = new ArrayList();
    private double last_time;
    private long coreToUseForInitialLoadBalancing = 0L;
    private final Hashtable<ISchedulableProcess, Long> all_processes = new Hashtable();

    public SimProcessorSharingResourceLinuxO1(SchedulerModel model, String name, String id, Long numberOfCores, IResourceTableManager resourceTableManager) {
        super(model, numberOfCores, name, id, resourceTableManager);
        long j = 0L;
        while (j < numberOfCores) {
            this.running_processesPerCore.add(new Hashtable());
            ++j;
        }
    }

    public void scheduleNextEvent() {
        ISchedulableProcess shortest = null;
        Double shortestTime = 0.0;
        for (Hashtable<ISchedulableProcess, Double> running_processes : this.running_processesPerCore) {
            for (ISchedulableProcess process : running_processes.keySet()) {
                if (shortest != null && !(shortestTime > running_processes.get(process) * this.getSpeed(process))) continue;
                shortest = process;
                shortestTime = running_processes.get(process) * this.getSpeed(process);
            }
        }
        this.processingFinished.removeEvent();
        if (shortest != null) {
            double time = shortestTime;
            if (!MathTools.less((double)0.0, (double)time)) {
                time = 0.0;
            }
            this.processingFinished.schedule(shortest, time);
        }
    }

    private int getCoreOfARunningProcess(ISchedulableProcess process) {
        int i = 0;
        while (i < this.running_processesPerCore.size()) {
            Hashtable<ISchedulableProcess, Double> running_processes = this.running_processesPerCore.get(i);
            if (running_processes.containsKey(process)) {
                return i;
            }
            ++i;
        }
        LoggingWrapper.LOGGER.warn((Object)"Core of process not found. Returning core 0.");
        return 0;
    }

    private int getCoreWithLongestQueue() {
        int coreWithLongestQueue = 0;
        int queueSize = 0;
        int i = 0;
        while (i < this.running_processesPerCore.size()) {
            if (this.running_processesPerCore.get(i).size() > queueSize) {
                queueSize = this.running_processesPerCore.get(i).size();
                coreWithLongestQueue = i;
            }
            ++i;
        }
        return coreWithLongestQueue;
    }

    private int getCoreWithShortestQueue() {
        int coreWithShortestQueue = -1;
        int queueSize = 0;
        int i = 0;
        while (i < this.running_processesPerCore.size()) {
            if (coreWithShortestQueue == -1) {
                queueSize = this.running_processesPerCore.get(i).size();
                coreWithShortestQueue = i;
            } else if (this.running_processesPerCore.get(i).size() < queueSize) {
                queueSize = this.running_processesPerCore.get(i).size();
                coreWithShortestQueue = i;
            }
            ++i;
        }
        return coreWithShortestQueue;
    }

    private void toNow() {
        double now = this.getModel().getSimulationControl().getCurrentSimulationTime();
        double passed_time = now - this.last_time;
        if (MathTools.less((double)0.0, (double)passed_time)) {
            for (Hashtable<ISchedulableProcess, Double> running_processes : this.running_processesPerCore) {
                for (Map.Entry<ISchedulableProcess, Double> e : running_processes.entrySet()) {
                    double processPassedTime = passed_time / this.getSpeed(e.getKey());
                    double rem = e.getValue() - processPassedTime;
                    e.setValue(rem);
                }
            }
        }
        this.last_time = now;
    }

    @Override
    public double getRemainingDemand(ISchedulableProcess process) {
        boolean hasDemand = false;
        for (Hashtable<ISchedulableProcess, Double> running_processes : this.running_processesPerCore) {
            if (!running_processes.containsKey(process)) continue;
            hasDemand = true;
            break;
        }
        if (!hasDemand) {
            return 0.0;
        }
        this.toNow();
        for (Hashtable<ISchedulableProcess, Double> running_processes : this.running_processesPerCore) {
            if (running_processes.contains(process)) continue;
            return running_processes.get(process);
        }
        return 0.0;
    }

    @Override
    public void updateDemand(ISchedulableProcess process, double demand) {
        block0: for (Hashtable<ISchedulableProcess, Double> running_processes : this.running_processesPerCore) {
            for (Map.Entry<ISchedulableProcess, Double> e : running_processes.entrySet()) {
                if (!e.getKey().equals(process)) continue;
                e.setValue(demand);
                continue block0;
            }
        }
        this.scheduleNextEvent();
    }

    private double getSpeed(ISchedulableProcess process) {
        int core = this.getCoreOfARunningProcess(process);
        double speed = this.running_processesPerCore.get(core).size();
        return speed < 1.0 ? 1.0 : speed;
    }

    @Override
    public void start() {
    }

    @Override
    protected void dequeue(ISchedulableProcess process) {
    }

    @Override
    protected void doProcessing(ISchedulableProcess process, int resourceServiceID, double demand) {
        this.toNow();
        LoggingWrapper.log("PS: " + process + " demands " + demand);
        long coreToPutOn = this.getLastCoreProcessWasRunningOn(process);
        if (coreToPutOn == -1L) {
            this.coreToUseForInitialLoadBalancing = 0L;
            if (this.running_processesPerCore.get((int)this.coreToUseForInitialLoadBalancing).size() > 0) {
                this.coreToUseForInitialLoadBalancing = this.nextLong(new Random(), this.getCapacity());
            }
            this.putProcessOnCore(process, demand, this.coreToUseForInitialLoadBalancing);
            int coreToBalanceFrom = this.getCoreWithLongestQueue();
            if (this.running_processesPerCore.get(coreToBalanceFrom).size() > 1) {
                DoLoadBalancingEvent event = new DoLoadBalancingEvent(this.getModel());
                double simTime = this.getModel().getSimulationControl().getCurrentSimulationTime();
                event.schedule((IEntity)IEntity.NULL, simTime + 1.0);
            }
        } else {
            this.putProcessOnCore(process, demand, coreToPutOn);
        }
        this.toNow();
        this.scheduleNextEvent();
        process.passivate();
    }

    private long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    protected void enqueue(ISchedulableProcess process) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void registerProcess(ISchedulableProcess process) {
    }

    @Override
    public int getQueueLengthFor(SchedulerEntity schedulerEntity, int coreID) {
        return this.running_processesPerCore.get(coreID).size();
    }

    private long getLastCoreProcessWasRunningOn(ISchedulableProcess process) {
        if (this.all_processes.containsKey(process)) {
            return this.all_processes.get(process);
        }
        return -1L;
    }

    private void putProcessOnCore(ISchedulableProcess process, double demand, long core) {
        if (this.all_processes.containsKey(process)) {
            this.all_processes.remove(process);
        }
        this.all_processes.put(process, core);
        this.running_processesPerCore.get((int)core).put(process, demand);
    }

    private class DoLoadBalancingEvent
    extends AbstractSimEventDelegator<NullEntity> {
        public DoLoadBalancingEvent(SchedulerModel model) {
            super((ISimulationModel)model, SimProcessorSharingResourceLinuxO1.class.getName());
        }

        public void eventRoutine(NullEntity who) {
            int coreToBalanceTo = SimProcessorSharingResourceLinuxO1.this.getCoreWithShortestQueue();
            int coreToBalanceFrom = SimProcessorSharingResourceLinuxO1.this.getCoreWithLongestQueue();
            if (SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(coreToBalanceFrom).size() - SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(coreToBalanceTo).size() > 1) {
                Hashtable<ISchedulableProcess, Double> runningProcesses = SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(coreToBalanceFrom);
                ISchedulableProcess[] processes = runningProcesses.keySet().toArray(new ISchedulableProcess[0]);
                Random random = new Random();
                ISchedulableProcess processToBalance = processes[random.nextInt(processes.length)];
                double simTime = this.getModel().getSimulationControl().getCurrentSimulationTime();
                if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                    LOGGER.info((Object)(String.valueOf(simTime) + ": Balancing process: " + processToBalance.getId() + " from core " + coreToBalanceFrom + " to " + coreToBalanceTo));
                }
                Double processValue = runningProcesses.get(processToBalance);
                runningProcesses.remove(processToBalance);
                SimProcessorSharingResourceLinuxO1.this.putProcessOnCore(processToBalance, processValue, coreToBalanceTo);
            }
        }
    }

    private class ProcessingFinishedEvent
    extends AbstractSimEventDelegator<ISchedulableProcess> {
        public ProcessingFinishedEvent(SchedulerModel model) {
            super((ISimulationModel)model, ProcessingFinishedEvent.class.getName());
        }

        public void eventRoutine(ISchedulableProcess process) {
            int coreToBalanceFrom;
            ISchedulableProcess last = process;
            SimProcessorSharingResourceLinuxO1.this.toNow();
            int core = SimProcessorSharingResourceLinuxO1.this.getCoreOfARunningProcess(last);
            SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(core).remove(last);
            if (SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(core).size() == 0 && SimProcessorSharingResourceLinuxO1.this.running_processesPerCore.get(coreToBalanceFrom = SimProcessorSharingResourceLinuxO1.this.getCoreWithLongestQueue()).size() > 1) {
                DoLoadBalancingEvent event = new DoLoadBalancingEvent(SimProcessorSharingResourceLinuxO1.this.getModel());
                double simTime = this.getModel().getSimulationControl().getCurrentSimulationTime();
                event.schedule((IEntity)IEntity.NULL, simTime + 1.0);
            }
            SimProcessorSharingResourceLinuxO1.this.scheduleNextEvent();
            last.activate();
        }
    }
}

