/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.passive;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.sensors.IPassiveResourceSensor;
import java.util.ArrayList;
import java.util.List;

public class PassiveResourceObservee {
    private final List<IPassiveResourceSensor> observers = new ArrayList<IPassiveResourceSensor>();

    public void fireRequest(ISchedulableProcess process, long num) {
        for (IPassiveResourceSensor o : this.observers) {
            o.request(process, num);
        }
    }

    public void fireAquire(ISchedulableProcess process, long num) {
        for (IPassiveResourceSensor o : this.observers) {
            o.acquire(process, num);
        }
    }

    public void fireRelease(ISchedulableProcess process, long num) {
        for (IPassiveResourceSensor o : this.observers) {
            o.release(process, num);
        }
    }

    public void addObserver(IPassiveResourceSensor observer) {
        this.observers.add(observer);
    }

    public void removeObserver(IPassiveResourceSensor observer) {
        this.observers.remove(observer);
    }
}

