/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.filter;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.filter.AbstractMeasurementsCollection;
import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import de.uka.ipd.sdq.sensorframework.filter.WarmupFilteredCollection;
import java.util.Collection;
import java.util.Properties;

public class WarmupFilteredFactory
implements IFilteredCollectionFactory {
    protected Properties filterProperties = new Properties();
    public static final String WARMUP = "Warm Up";
    public static final long DEFAULT_WARMUP = 2500L;

    public WarmupFilteredFactory() {
        this.filterProperties.put(WARMUP, (Object)2500L);
    }

    @Override
    public AbstractMeasurementsCollection getFilteredCollection(Collection<Measurement> filtrate) {
        return new WarmupFilteredCollection(filtrate, 2500L);
    }

    @Override
    public Properties getProperties() {
        return this.filterProperties;
    }

    @Override
    public void setProperties(Properties newProperties) {
        this.filterProperties = newProperties;
    }

    @Override
    public boolean canFilter(Collection<Measurement> filtrate, Number attribute) {
        return attribute.longValue() < (long)filtrate.size();
    }

    @Override
    public AbstractMeasurementsCollection getFilteredCollection(Collection<Measurement> filtrate, Number parameter) {
        this.filterProperties.put(WARMUP, (Object)parameter.longValue());
        return new WarmupFilteredCollection(filtrate, parameter.longValue());
    }

    @Override
    public String getFilterFactoryID() {
        return "Warm Up Filter";
    }

    @Override
    public Long convertToType(String type) {
        return Long.parseLong(type);
    }
}

