/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.filter;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.filter.AbstractMeasurementsCollection;
import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import de.uka.ipd.sdq.sensorframework.filter.OutlierFilteredCollection;
import java.util.Collection;
import java.util.Properties;

public class OutlierFilteredFactory
implements IFilteredCollectionFactory {
    protected Properties filterProperties = new Properties();
    private static final String OUTLIER = "Outlier removal";
    private static final double DEFAULT_OUTLIER = 0.1;

    public OutlierFilteredFactory() {
        this.filterProperties.put(OUTLIER, (Object)0.1);
    }

    @Override
    public AbstractMeasurementsCollection getFilteredCollection(Collection<Measurement> filtrate) {
        return new OutlierFilteredCollection(filtrate, 0.1);
    }

    @Override
    public Properties getProperties() {
        return this.filterProperties;
    }

    @Override
    public void setProperties(Properties newProperties) {
        this.filterProperties = newProperties;
    }

    @Override
    public boolean canFilter(Collection<Measurement> filtrate, Number attribute) {
        return attribute.doubleValue() < 1.0;
    }

    @Override
    public AbstractMeasurementsCollection getFilteredCollection(Collection<Measurement> filtrate, Number parameter) {
        this.filterProperties.put(OUTLIER, (Object)parameter.doubleValue());
        return new OutlierFilteredCollection(filtrate, parameter.doubleValue());
    }

    @Override
    public String getFilterFactoryID() {
        return "Outlier Filter";
    }

    @Override
    public Double convertToType(String type) {
        return Double.parseDouble(type);
    }
}

