/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.storage.lists;

import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;

public class DoubleSerialiser
implements ISerialiser<Double> {
    @Override
    public long getElementLength() {
        return 8L;
    }

    @Override
    public byte[] serialise(Object[] objects, int count) {
        byte[] block = new byte[(int)((long)count * this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < count) {
            long l = Double.doubleToRawLongBits((Double)objects[j]);
            int i = 0;
            while (i < 8) {
                block[blockPos++] = (byte)(l & 0xFFL);
                l >>= 8;
                ++i;
            }
            ++j;
        }
        return block;
    }

    public Double[] deserialise(byte[] bytes) {
        Double[] doubles = new Double[(int)((long)bytes.length / this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < doubles.length) {
            long l = 0L;
            int i = 7;
            while (i >= 0) {
                l <<= 8;
                l |= (long)(bytes[blockPos + i] < 0 ? 256 + bytes[blockPos + i] : bytes[blockPos + i]);
                --i;
            }
            blockPos += 8;
            doubles[j] = Double.longBitsToDouble(l);
            ++j;
        }
        return doubles;
    }
}

