/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistogramAccepter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class LoadCSVHistogram
extends Action {
    private Histogram histogram = null;
    private final IHistogramAccepter viewer;

    public Histogram getHistogram() {
        return this.histogram;
    }

    public LoadCSVHistogram(IHistogramAccepter freeChartHistogramViewer) {
        this.setText("Load CSV...");
        this.viewer = freeChartHistogramViewer;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        if (dialog.getFileName() != null) {
            this.histogram = this.importHistogram(String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName());
        }
        this.viewer.addHistogram(this.histogram);
    }

    private Histogram importHistogram(String fileName) {
        Histogram h = new Histogram("Measurements");
        BufferedReader bufferedReader = null;
        try {
            try {
                String row;
                FileReader fileReader = new FileReader(fileName);
                bufferedReader = new BufferedReader(fileReader);
                while ((row = bufferedReader.readLine()) != null) {
                    String[] parts = row.split(";");
                    double x = Double.parseDouble(parts[0].replace(',', '.'));
                    double y = Double.parseDouble(parts[1].replace(',', '.'));
                    h.addEntity(new HistogramBucketInformation(y, x));
                }
            }
            catch (Exception exception) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        for (HistogramBucketInformation e : h.getBucketInformation()) {
            System.out.print("runif(" + Math.round(e.getProbability() * 100000.0) + "," + (e.getValue() - 5.0) + "," + (e.getValue() + 5.0) + "),");
        }
        return h;
    }
}

