/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Utilization;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.UtilizationBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IUtilizationAccepter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class LoadCSVUtilization
extends Action {
    private static final Logger LOGGER = Logger.getLogger((String)LoadCSVUtilization.class.getCanonicalName());
    private Utilization utilization;
    private final IUtilizationAccepter viewer;

    public Utilization getUtilization() {
        return this.utilization;
    }

    public LoadCSVUtilization(IUtilizationAccepter freeChartUtilizationViewer) {
        this.setText("Load Utilization CSV...");
        this.viewer = freeChartUtilizationViewer;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        if (dialog.getFileName() != null) {
            this.utilization = this.importUtilization(String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName());
        }
        if (this.viewer != null) {
            this.viewer.addUtilization(this.utilization);
        }
    }

    private Utilization importUtilization(String fileName) {
        Utilization utilization = new Utilization("Measurements");
        try {
            String row;
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((row = bufferedReader.readLine()) != null) {
                String[] parts = row.split(";");
                double utilizationValue = Double.parseDouble(parts[0].replace(',', '.'));
                double eventTimeStart = Double.parseDouble(parts[1].replace(',', '.'));
                double eventTimeEnd = Double.parseDouble(parts[2].replace(',', '.'));
                utilization.setBucketWidth(eventTimeEnd - eventTimeStart);
                utilization.addEntity(new UtilizationBucketInformation(utilizationValue, eventTimeStart));
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not load utilization values from CSV file.", (Throwable)e);
        }
        return utilization;
    }
}

