/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.IVisualisation;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.IReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reports.RReport;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RConnectionImpl;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.views.AbstractHtmlReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.views.HTMLVisitor;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractHtmlRReportView
extends AbstractHtmlReportView
implements IVisualisation<SensorAndMeasurements> {
    public abstract RReport getReport();

    @Override
    public void setInput(Collection<SensorAndMeasurements> c) {
        if (RConnectionImpl.isEngineAvailable()) {
            if (c.isEmpty()) {
                this.browser.setText("<html><body><h1>Error! </h1>At least the measurements for one sensor must be available!</body></html>");
            } else if (this.getReport() == null) {
                this.browser.setText("<html><body><h1>Error!</h1> There is no report associated with this view. Ask the developer to correct this error. </body></html>");
            } else {
                RConnectionImpl rConnection = RConnectionImpl.getRConnection();
                ArrayList<IReportItem> items = this.getReport().prepareReportItems(c, rConnection);
                HTMLVisitor visitor = new HTMLVisitor();
                for (IReportItem item : items) {
                    item.generateData(rConnection);
                    item.visit(visitor);
                }
                this.browser.setText(visitor.getHTML());
            }
        } else {
            this.browser.setText("<html><body><h1>Error! </h1>Connection to R engine is not available!</body></html>");
        }
    }
}

