/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.editor;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.filter.FilteredCollectionsManager;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInputFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ConfigEditorInput
extends Observable
implements IEditorInput,
IPersistableElement,
IAdaptable,
Observer {
    private final FilteredCollectionsManager filtersManager = new FilteredCollectionsManager();
    private final List<ConfigEntry> configEntrys = new ArrayList<ConfigEntry>();
    private final String adapterFactoryID;

    public ConfigEditorInput(String adapterFactoryID) {
        this.adapterFactoryID = adapterFactoryID;
    }

    public ConfigEditorInput(String adapterFactoryID, ConfigEntry configEntry) {
        this.adapterFactoryID = adapterFactoryID;
        this.addConfigEntry(configEntry);
    }

    public void editConfigEntry(IDAOFactory datasource, ExperimentRun run, Experiment experiment, Sensor sensor, String adapterFactoryID) {
        ConfigEntry configEntry = this.getConfigEntryToRun(run);
        if (configEntry == null) {
            ConfigEntry confEntry = new ConfigEntry(datasource, run, experiment, sensor);
            confEntry.addObserver(this);
            this.configEntrys.add(confEntry);
        } else {
            configEntry.setSensorChecked(sensor);
        }
        this.notifyObserver();
    }

    public void addConfigEntry(ConfigEntry configEntry) {
        configEntry.addObserver(this);
        this.configEntrys.add(configEntry);
        this.notifyObserver();
    }

    public void removeConfigEntry(ConfigEntry entry) {
        if (this.configEntrys.contains(entry)) {
            entry.deleteObserver(this);
            this.configEntrys.remove(entry);
            this.notifyObserver();
        }
    }

    public ConfigEntry getConfigEntryToRun(ExperimentRun run) {
        for (ConfigEntry re : this.configEntrys) {
            if (!re.getExperimentRun().equals(run)) continue;
            return re;
        }
        return null;
    }

    public List<ConfigEntry> getConfigEntrys() {
        return this.configEntrys;
    }

    public boolean isEmpty() {
        return this.configEntrys.isEmpty();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return "";
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ConfigEditorInput.class) {
            return this;
        }
        return null;
    }

    public String getFactoryId() {
        return ConfigEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        try {
            ConfigEditorInputFactory.saveState(memento, this);
        }
        catch (Exception exception) {}
    }

    private void notifyObserver() {
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.notifyObserver();
    }

    public static String getPathToConfigFile() {
        IPath path = VisualisationPlugin.getDefault().getStateLocation();
        return String.valueOf(path.toPortableString()) + "/" + "persistable_element.xml";
    }

    public String getAdapterFactoryID() {
        return this.adapterFactoryID;
    }

    public FilteredCollectionsManager getFiltersManager() {
        return this.filtersManager;
    }
}

