/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.editor;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class ConfigEntry
extends Observable {
    private final List<Long> sensorIDs;
    private final long experimentRunID;
    private long experimentID;
    private final long datasourceID;

    public ConfigEntry(IDAOFactory factory, ExperimentRun experimentRun, Experiment experiment, Sensor sensor) {
        this.datasourceID = factory.getID();
        this.experimentRunID = experimentRun.getExperimentRunID();
        this.experimentID = experiment.getExperimentID();
        this.sensorIDs = new ArrayList<Long>();
        if (sensor != null) {
            this.sensorIDs.add(sensor.getSensorID());
        }
    }

    public List<Sensor> getSensors() {
        ArrayList<Sensor> result = new ArrayList<Sensor>();
        for (long sensorID : this.sensorIDs) {
            result.add(this.getDatasource().createSensorDAO().get(sensorID));
        }
        return result;
    }

    public void setSensorChecked(Sensor sensor) {
        if (!this.isSensorChecked(sensor)) {
            this.sensorIDs.add(sensor.getSensorID());
            this.setChanged();
        }
        this.notifyObservers();
    }

    public void setSensorUnchecked(Sensor sensor) {
        this.sensorIDs.remove(sensor.getSensorID());
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isSensorChecked(Sensor sensor) {
        if (this.sensorIDs != null) {
            return this.sensorIDs.contains(sensor.getSensorID());
        }
        return false;
    }

    public ExperimentRun getExperimentRun() {
        return this.getDatasource().createExperimentRunDAO().get(this.experimentRunID);
    }

    public Experiment getExperiment() {
        return this.getDatasource().createExperimentDAO().get(this.experimentID);
    }

    public void setExperiment(Experiment experiment) {
        this.experimentID = experiment.getExperimentID();
    }

    public IDAOFactory getDatasource() {
        return SensorFrameworkDataset.singleton().getDataSourceByID(this.datasourceID);
    }
}

