/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ViewAndAdapterFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.SensorValidationToView;
import de.uka.ipd.sdq.sensorframework.visualisation.menu.DoubleClickAction;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DoubleClickListener
implements IDoubleClickListener {
    private DoubleClickAction doubleClickAction;

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection;
        Object object;
        if (event.getSelection() instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof TreeObject) {
            TreeObject treeObject = (TreeObject)object;
            Object innerObject = treeObject.getObject();
            ExperimentRun run = treeObject.getRun();
            if (innerObject instanceof Sensor && run != null) {
                Sensor sensor = (Sensor)innerObject;
                SensorAndMeasurements sam = run.getMeasurementsOfSensor(sensor);
                if (sam.getMeasurements().size() != 0) {
                    Object[] viewers = SensorValidationToView.findViews(sam);
                    ViewAndAdapterFactory selecedView = SensorValidationToView.getSelectedAction(event.getViewer().getControl().getShell(), viewers);
                    if (selecedView != null) {
                        ConfigEditorInput editorInput = new ConfigEditorInput(selecedView.getFactory().getAdapterFactoryID());
                        ConfigEntry configEntry = new ConfigEntry(treeObject.getDatasource(), treeObject.getRun(), treeObject.getExperiment(), sensor);
                        editorInput.addConfigEntry(configEntry);
                        IConfigurationElement action = selecedView.getView();
                        this.hookDoubleClickAction(editorInput, action.getAttribute("editorID"));
                    }
                } else {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Empty Sensor", (String)"The selected sensor does not contain measurements in the selected Experiment Run. Refused to open view.");
                }
            }
        }
    }

    private void hookDoubleClickAction(ConfigEditorInput editorInput, String editorID) {
        this.doubleClickAction = new DoubleClickAction(editorInput, editorID);
        this.doubleClickAction.run();
    }
}

