/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.ViewAndAdapterFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.SensorValidationToView;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorInputTransfer;

public class TreeDragSourceListener
implements DragSourceListener {
    TreeViewer viewer;

    public TreeDragSourceListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object object = selection.getFirstElement();
        Object[] viewers = null;
        if (EditorInputTransfer.getInstance().isSupportedType(event.dataType)) {
            ViewAndAdapterFactory selectedView;
            TreeObject treeObject = (TreeObject)object;
            Object innerObject = treeObject.getObject();
            if (innerObject instanceof Sensor) {
                Sensor sensor = (Sensor)innerObject;
                viewers = SensorValidationToView.findViews(treeObject.getRun().getMeasurementsOfSensor(sensor));
            }
            if (innerObject instanceof ExperimentRun) {
                viewers = SensorValidationToView.getConfigurationElements();
            }
            if ((selectedView = SensorValidationToView.getSelectedAction(event.display.getActiveShell(), viewers)) != null) {
                EditorInputTransfer.EditorInputData[] transferArray;
                ConfigEntry configEntry;
                ConfigEditorInput editorInput = new ConfigEditorInput(selectedView.getFactory().getAdapterFactoryID());
                if (innerObject instanceof Sensor) {
                    Sensor sensor = (Sensor)innerObject;
                    configEntry = new ConfigEntry(treeObject.getDatasource(), treeObject.getRun(), treeObject.getExperiment(), sensor);
                    editorInput.addConfigEntry(configEntry);
                }
                if (innerObject instanceof ExperimentRun) {
                    ExperimentRun run = (ExperimentRun)innerObject;
                    configEntry = new ConfigEntry(treeObject.getDatasource(), run, treeObject.getExperiment(), null);
                    editorInput.addConfigEntry(configEntry);
                }
                event.data = transferArray = new EditorInputTransfer.EditorInputData[]{EditorInputTransfer.createEditorInputData((String)selectedView.getView().getAttribute("editorID"), (IEditorInput)editorInput)};
            } else {
                event.data = null;
                event.doit = false;
            }
        } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object object = selection.getFirstElement();
        event.doit = false;
        if (object instanceof TreeObject) {
            event.doit = true;
            TreeObject treeObject = (TreeObject)object;
            ExperimentRun run = treeObject.getRun();
            if (treeObject.getObject() instanceof Sensor && run == null) {
                event.doit = false;
            }
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

