/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.SensorValidationToView;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ViewDropTargetListener
extends DropTargetAdapter {
    private final ConfigEditorInput configEditorInput;

    public ViewDropTargetListener(IEditorInput editorInput) {
        this.configEditorInput = (ConfigEditorInput)editorInput;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void drop(DropTargetEvent event) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof TreeObject) {
            ExperimentRun run;
            TreeObject treeObject = (TreeObject)object;
            Object innerObject = treeObject.getObject();
            if (innerObject instanceof Sensor) {
                Sensor sensor = (Sensor)innerObject;
                ExperimentRun run2 = treeObject.getRun();
                Experiment experiment = treeObject.getExperiment();
                SensorAndMeasurements sam = run2.getMeasurementsOfSensor(sensor);
                if (sam.getMeasurements().size() > 0) {
                    if (SensorValidationToView.canViewSensor(sam)) {
                        this.configEditorInput.editConfigEntry(treeObject.getDatasource(), run2, experiment, sensor, null);
                    } else {
                        SensorValidationToView.showMessage(event.display.getActiveShell());
                    }
                } else {
                    MessageDialog.openWarning((Shell)event.display.getActiveShell(), (String)"Empty Sensor", (String)"The dropped sensor does not contain measurements in the selected Experiment Run. Refused to add sensor to view.");
                }
            }
            if (innerObject instanceof ExperimentRun && this.configEditorInput.getConfigEntryToRun(run = (ExperimentRun)innerObject) == null) {
                ConfigEntry configEntry = new ConfigEntry(treeObject.getDatasource(), run, treeObject.getExperiment(), null);
                this.configEditorInput.addConfigEntry(configEntry);
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

