/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileManager;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractFileEntity;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.SensorImpl;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.SerializableEntity;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.storage.lists.BackgroundMemoryList;
import de.uka.ipd.sdq.sensorframework.storage.lists.DoubleSerialiser;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class AbstractSensorAndMeasurements
extends AbstractFileEntity
implements SerializableEntity {
    private static final long serialVersionUID = 1L;
    protected static final String EVENT_TIME_SUFFIX = "ET";
    protected static final String MEASUREMENTS_SUFFIX = "MEAS";
    protected ExperimentRun experimentRun;
    protected Sensor sensor;
    protected BackgroundMemoryList<Double> eventTimes;
    private final FileManager fm;

    public AbstractSensorAndMeasurements(FileManager fm, ExperimentRun exprun, Sensor sensor) throws IOException {
        super(fm.getDAOFactory());
        this.sensor = sensor;
        this.experimentRun = exprun;
        this.fm = fm;
        this.eventTimes = new BackgroundMemoryList(this.getEventTimeFileName(), (ISerialiser)new DoubleSerialiser());
        fm.addOpenList(this.eventTimes);
    }

    protected String getEventTimeFileName() {
        return String.valueOf(this.fm.getRootDirectory()) + File.separator + "exprun" + this.experimentRun.getExperimentRunID() + "_" + this.sensor.getSensorID() + "_" + EVENT_TIME_SUFFIX + ".ser";
    }

    public String getFileName() {
        return "exprun" + this.experimentRun.getExperimentRunID() + "_" + this.sensor.getSensorID();
    }

    @Override
    public long getID() {
        throw new UnsupportedOperationException();
    }

    public abstract List<Measurement> getMeasurements();

    protected String getMeasurementsFileName() {
        return String.valueOf(this.fm.getRootDirectory()) + File.separator + "exprun" + this.experimentRun.getExperimentRunID() + "_" + this.sensor.getSensorID() + "_" + MEASUREMENTS_SUFFIX + ".ser";
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public void setSensor(SensorImpl sensor) {
        this.sensor = sensor;
    }

    public void store() {
        try {
            this.eventTimes.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

