/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.storage.lists.BackgroundMemoryList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class FileManager {
    private final String rootDirectory;
    private final FileDAOFactory factory;
    private final ArrayList<BackgroundMemoryList<?>> openLists = new ArrayList();

    public FileManager(String rootDirectory, FileDAOFactory factory) {
        this.checkPath(rootDirectory);
        this.rootDirectory = rootDirectory;
        this.factory = factory;
    }

    private void checkPath(String path) {
        File f = new File(path);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("Error: " + path + " is not a directory!");
        }
    }

    public boolean removeFile(String filename) {
        File path = new File(new File(this.rootDirectory), filename.endsWith(".ser") ? filename : String.valueOf(filename) + ".ser");
        return path.delete();
    }

    public void serializeToFile(String filename, Serializable ser) {
        OutputStream fos = null;
        File path = new File(new File(this.rootDirectory), String.valueOf(filename) + ".ser");
        try {
            try {
                fos = new FileOutputStream(path);
                ObjectOutputStream o = new ObjectOutputStream(fos);
                o.writeObject(ser);
            }
            catch (IOException e) {
                throw new RuntimeException("Serialisation of DAO failed.", e);
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Serialisation of DAO failed.", e);
            }
        }
    }

    public Serializable deserializeFromFile(String fileName) {
        File path = new File(new File(this.rootDirectory), String.valueOf(fileName) + ".ser");
        return this.deserializeFromFile(path);
    }

    public Serializable deserializeFromFile(File file) {
        Serializable result = null;
        InputStream fis = null;
        if (file.exists()) {
            try {
                try {
                    fis = new FileInputStream(file);
                    ObjectInputStream o = new ObjectInputStream(fis);
                    result = (Serializable)o.readObject();
                }
                catch (IOException e) {
                    throw new RuntimeException("Sensorframework File Provider failed loading an entity", e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Sensorframework File Provider failed loading an entity", e);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Sensorframework File Provider failed loading an entity", e);
                }
            }
        }
        return result;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void addOpenList(BackgroundMemoryList<?> list) {
        this.openLists.add(list);
    }

    public void closeAllLists() {
        for (BackgroundMemoryList<?> list : this.openLists) {
            try {
                list.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.openLists.clear();
    }

    public IDAOFactory getDAOFactory() {
        return this.factory;
    }

    public void flush() {
        for (BackgroundMemoryList<?> list : this.openLists) {
            try {
                list.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

