/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.entities.base;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilityMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractExperimentRun
implements ExperimentRun {
    protected transient IDAOFactory myDAOFactory = null;
    private String m_experimentDateTime;
    private long m_experimentRunID;
    private final Collection<Measurement> m_measurements = new ArrayList<Measurement>();

    public AbstractExperimentRun(IDAOFactory myFactory) {
        this.myDAOFactory = myFactory;
    }

    @Override
    public String getExperimentDateTime() {
        return this.m_experimentDateTime;
    }

    @Override
    public void setExperimentDateTime(String value) {
        this.m_experimentDateTime = value;
    }

    @Override
    public long getExperimentRunID() {
        return this.m_experimentRunID;
    }

    @Override
    public void setExperimentRunID(long value) {
        this.m_experimentRunID = value;
    }

    @Override
    public StateMeasurement addStateMeasurement(StateSensor p_sensor, State p_sensorstate, double p_eventtime) {
        StateMeasurement result = this.myDAOFactory.createMeasurementDAO().addStateMeasurement(p_sensor, p_sensorstate, p_eventtime);
        this.m_measurements.add(result);
        return result;
    }

    @Override
    public TimeSpanMeasurement addTimeSpanMeasurement(TimeSpanSensor p_sensor, double p_eventtime, double p_timespan) {
        TimeSpanMeasurement result = this.myDAOFactory.createMeasurementDAO().addTimeSpanMeasurement(p_sensor, p_eventtime, p_timespan);
        this.m_measurements.add(result);
        return result;
    }

    @Override
    public ScalabilityMeasurement addScalabilityMeasurement(ScalabilitySensor p_sensor, Double[] p_parameters, double p_result) {
        ScalabilityMeasurement result = this.myDAOFactory.createMeasurementDAO().addScalabilityMeasurement(p_sensor, p_parameters, p_result);
        this.m_measurements.add(result);
        return result;
    }

    @Override
    public void addMeasurement(Measurement value) {
        this.m_measurements.add(value);
    }

    @Override
    public Collection<Measurement> getMeasurements() {
        return this.m_measurements;
    }

    @Override
    public abstract SensorAndMeasurements getMeasurementsOfSensor(Sensor var1);
}

