/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractFileEntity;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.ExperimentRunImpl;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.SerializableEntity;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ExperimentImpl
extends AbstractFileEntity
implements Experiment,
SerializableEntity {
    private static final long serialVersionUID = 2145970711062278629L;
    private long experimentID;
    private String experimentName;
    private final Collection<Long> sensors = new ArrayList<Long>();
    private final Collection<Long> experimentRuns = new ArrayList<Long>();

    public ExperimentImpl(IDAOFactory factory) {
        super(factory);
    }

    @Override
    public void addExperimentRun(ExperimentRun experimentRun) {
        this.experimentRuns.add(experimentRun.getExperimentRunID());
    }

    @Override
    public ExperimentRun addExperimentRun(String experimentdatetime) {
        ExperimentRun expRun = this.factory.createExperimentRunDAO().addExperimentRun(experimentdatetime);
        this.experimentRuns.add(expRun.getExperimentRunID());
        ((ExperimentRunImpl)expRun).setParentExperimentID(this.getID());
        return expRun;
    }

    @Override
    public ExperimentRun addScalabilityExperimentRun(String experimentdatetime) {
        ExperimentRun expRun = this.factory.createExperimentRunDAO().addScalabilityExperimentRun(experimentdatetime);
        this.experimentRuns.add(expRun.getExperimentRunID());
        ((ExperimentRunImpl)expRun).setParentExperimentID(this.getID());
        return expRun;
    }

    @Override
    public ScalabilitySensor addScalabilitySensor(String sensorName) {
        ScalabilitySensor scals = this.factory.createSensorDAO().addScalabilitySensor(sensorName);
        this.sensors.add(scals.getSensorID());
        return scals;
    }

    @Override
    public void addSensor(Sensor value) {
        this.sensors.add(value.getSensorID());
    }

    @Override
    public StateSensor addStateSensor(State p_initialstate, String p_sensorname) {
        StateSensor stsen = this.factory.createSensorDAO().addStateSensor(p_initialstate, p_sensorname);
        this.sensors.add(stsen.getSensorID());
        return stsen;
    }

    @Override
    public TimeSpanSensor addTimeSpanSensor(String sensorName) {
        TimeSpanSensor tss = this.factory.createSensorDAO().addTimeSpanSensor(sensorName);
        this.sensors.add(tss.getSensorID());
        return tss;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExperimentImpl)) {
            return false;
        }
        ExperimentImpl exp = (ExperimentImpl)obj;
        if (this.experimentID != exp.getExperimentID() || !this.experimentName.equals(exp.getExperimentName())) {
            return false;
        }
        if (!this.experimentRuns.equals(exp.getExperimentRuns())) {
            return false;
        }
        return this.sensors.equals(exp.getSensors());
    }

    @Override
    public long getExperimentID() {
        return this.experimentID;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public Collection<ExperimentRun> getExperimentRuns() {
        ArrayList<ExperimentRun> result = new ArrayList<ExperimentRun>();
        for (Long id : this.experimentRuns) {
            result.add(this.factory.createExperimentRunDAO().get(id));
        }
        return Collections.unmodifiableCollection(result);
    }

    public String getFileName() {
        return "experiment" + this.getExperimentID();
    }

    @Override
    public long getID() {
        return this.getExperimentID();
    }

    @Override
    public Collection<Sensor> getSensors() {
        ArrayList<Sensor> result = new ArrayList<Sensor>();
        for (Long id : this.sensors) {
            result.add(this.factory.createSensorDAO().get(id));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public void setExperimentID(long experimentID) {
        this.experimentID = experimentID;
    }

    @Override
    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    @Override
    public void setFactory(FileDAOFactory factory) {
        this.factory = factory;
    }
}

