/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.FileManager;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractSensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.StateMeasurementListWithBackgroundStore;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.StateSerializer;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.storage.lists.BackgroundMemoryList;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.IOException;
import java.util.List;

public class StateSensorAndMeasurement
extends AbstractSensorAndMeasurements {
    private static final long serialVersionUID = -7553464522648015852L;
    private final BackgroundMemoryList<State> states;

    public StateSensorAndMeasurement(FileManager fm, ExperimentRun er, Sensor sensor) throws IOException {
        super(fm, er, sensor);
        this.states = new BackgroundMemoryList(this.getMeasurementsFileName(), (ISerialiser)new StateSerializer((StateSensor)sensor));
        fm.addOpenList(this.states);
    }

    public void addState(double et, State state) {
        this.eventTimes.add((Object)et);
        this.states.add((Object)state);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StateSensorAndMeasurement)) {
            return false;
        }
        StateSensorAndMeasurement sam = (StateSensorAndMeasurement)obj;
        return super.equals(obj) && this.getStates().equals(sam.getStates());
    }

    @Override
    public List<Measurement> getMeasurements() {
        return new StateMeasurementListWithBackgroundStore((BackgroundMemoryList<Double>)this.eventTimes, this.states);
    }

    public List<State> getStates() {
        return this.states;
    }

    public void serializeChildren() {
    }

    @Override
    public void setFactory(FileDAOFactory factory) {
    }

    @Override
    public void store() {
        super.store();
        try {
            this.states.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

