/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.filter;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.filter.AbstractMeasurementsCollection;
import de.uka.ipd.sdq.sensorframework.filter.IFilteredCollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class FilteredCollectionsManager {
    private ArrayList<IFilteredCollectionFactory> factories = new ArrayList();
    IFilteredCollectionFactory factory;
    private static int count = 0;

    public Object getFilteredMeasurements(SensorAndMeasurements sam) {
        return new SensorAndMeasurements(sam.getSensor(), this.filteringTheMeasurements(sam.getMeasurements()));
    }

    private Collection<Measurement> filteringTheMeasurements(Collection<Measurement> measuremts) {
        if (this.factories.isEmpty() || count == this.factories.size()) {
            this.resetCount();
            return measuremts;
        }
        this.factory = this.factories.get(count++);
        AbstractMeasurementsCollection filteredCollection = this.factory.canFilter(measuremts, this.getProperty(this.factory.getProperties())) ? this.factory.getFilteredCollection(measuremts, this.getProperty(this.factory.getProperties())) : this.factory.getFilteredCollection(measuremts, this.factory.convertToType("0"));
        return this.filteringTheMeasurements(filteredCollection);
    }

    private Number getProperty(Properties properties) {
        String desc = properties.propertyNames().nextElement().toString();
        return (Number)properties.get(desc);
    }

    public void addFactory(IFilteredCollectionFactory factory) {
        this.factories.add(factory);
    }

    public void removeFactory(IFilteredCollectionFactory factory) {
        this.factories.remove(factory);
    }

    public ArrayList<IFilteredCollectionFactory> getFactories() {
        return this.factories;
    }

    public void setFactories(ArrayList<IFilteredCollectionFactory> factories) {
        this.factories = factories;
    }

    public void resetCount() {
        count = 0;
    }
}

