/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core;

import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.apache.impl.MT19937RandomGenerator;
import de.uka.ipd.sdq.probfunction.math.random.IRandomStream;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class SimuComDefaultRandomNumberGenerator
implements IRandomGenerator {
    private static final int MAX_PRODUCER_BUFFER_SIZE = 1000;
    private static final Logger LOGGER = Logger.getLogger((String)SimuComDefaultRandomNumberGenerator.class.getName());
    private static long streamCounter = 0L;
    private final long myID;
    private final IRandomStream rndNumberGenerator;
    private final LinkedBlockingQueue<Double> producerQueue = new LinkedBlockingQueue(1000);
    private final Thread producerThread;
    private volatile boolean finished = false;

    public SimuComDefaultRandomNumberGenerator(long[] randomSeed) {
        this.myID = streamCounter++;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Initialising random number generator! [Stream ID = " + this.myID + "]"));
        }
        this.rndNumberGenerator = new MT19937RandomGenerator();
        this.initRandomSeed(randomSeed);
        this.producerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Random number producer started! [Stream ID = " + SimuComDefaultRandomNumberGenerator.this.myID + "]"));
                }
                try {
                    while (!SimuComDefaultRandomNumberGenerator.this.finished) {
                        SimuComDefaultRandomNumberGenerator.this.producerQueue.put(SimuComDefaultRandomNumberGenerator.this.rndNumberGenerator.nextDouble());
                    }
                }
                catch (InterruptedException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Bad concurrency problem", (Throwable)e);
                    }
                    throw new RuntimeException("Unexpected interruption of concurrent threads");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Random number producer stopped! [Stream ID = " + SimuComDefaultRandomNumberGenerator.this.myID + "]"));
                }
            }
        });
        this.producerThread.start();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Random number stream initialised! [Stream ID = " + this.myID + "]"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initRandomSeed(long[] randomSeed) {
        if (randomSeed != null) {
            if (randomSeed.length != 6) throw new RuntimeException("Seed array must have length of six longs for initialising random number generator");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Setting fixed seed for random number generator! [Stream ID = " + this.myID + "]"));
                int i = 0;
                while (i < 6) {
                    LOGGER.debug((Object)("Seed " + i + " = " + randomSeed[i]));
                    ++i;
                }
            }
            this.rndNumberGenerator.setSeed(randomSeed);
            return;
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Setting random seed for random number generator! [Stream ID = " + this.myID + "]"));
            }
            long[] myRandomSeed = new long[6];
            Random r = new Random();
            int i = 0;
            while (i < myRandomSeed.length) {
                myRandomSeed[i] = r.nextInt();
                ++i;
            }
            this.rndNumberGenerator.setSeed(myRandomSeed);
        }
    }

    public double random() {
        double d;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Drawing a random number from random number stream [" + this.myID + "]!"));
        }
        try {
            d = this.producerQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected interruption of concurrent threads");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number is: " + d));
        }
        return d;
    }

    public void dispose() {
        this.finished = true;
        this.producerQueue.clear();
    }

    public void nextArrayOfDouble(double[] u, int start, int n) {
        int i = start;
        while (i < u.length && i - start < n) {
            u[i] = this.random();
            ++i;
        }
    }

    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        int index = start;
        while (index < u.length && index - start < n) {
            u[index] = this.nextInt(i, j);
            ++index;
        }
    }

    public double nextDouble() {
        return this.random();
    }

    public int nextInt(int i, int j) {
        return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
    }

    public void resetNextSubstream() {
    }

    public void resetStartStream() {
    }

    public void resetStartSubstream() {
    }
}

