/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core.resources;

import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.exceptions.ResourceContainerIsMissingRequiredResourceType;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;

public class SimulatedLinkingResourceContainer
extends AbstractSimulatedResourceContainer {
    public SimulatedLinkingResourceContainer(SimuComModel myModel, String id) {
        super(myModel, id);
    }

    public SimulatedLinkingResource addActiveResourceWithoutCalculators(LinkingResource linkingResource, String resourceContainerID) {
        SimulatedLinkingResource r = new SimulatedLinkingResource(linkingResource, this.myModel, resourceContainerID);
        this.activeResources.put(linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getId(), r);
        return r;
    }

    public void addActiveResource(LinkingResource linkingResource, String resourceContainerID) {
        SimulatedLinkingResource resource = this.addActiveResourceWithoutCalculators(linkingResource, resourceContainerID);
        CalculatorHelper.setupDemandCalculator(resource, this.myModel);
        CalculatorHelper.setupActiveResourceStateCalculators(resource, this.myModel);
    }

    public String getLinkingResourceId() {
        Iterator iterator = this.activeResources.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SimulatedLinkingResource resource = (SimulatedLinkingResource)entry.getValue();
            return resource.getId();
        }
        return null;
    }

    public void loadActiveResource(SimuComSimProcess requestingProcess, String originResourceContainerID, String typeID, double demand) {
        AbstractScheduledResource resource = (AbstractScheduledResource)this.activeResources.get(typeID);
        if (resource == null) {
            throw new ResourceContainerIsMissingRequiredResourceType(typeID);
        }
        resource.consumeResource(requestingProcess, 1, Collections.emptyMap(), demand);
    }

    public String getLinkingResourceTypeId() {
        Iterator iterator = this.activeResources.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SimulatedLinkingResource resource = (SimulatedLinkingResource)entry.getValue();
            return resource.getResourceTypeId();
        }
        return null;
    }
}

