/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.simulationdock;

import de.uka.ipd.sdq.simucomframework.core.IModelledApp;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simulationdock.DebugObserver;
import de.uka.ipd.sdq.simucomframework.simulationdock.DispatchingSimulationObserver;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationProgressReportingObserver;
import de.uka.ipd.sdq.simulation.core.AbstractSimulationConfig;
import de.uka.ipd.sdq.simulation.core.ISimulationControl;
import de.uka.ipd.sdq.simulation.core.IStatusObserver;
import de.uka.ipd.sdq.simulation.core.SimulationResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class SimulationDockServiceImpl
implements SimulationDockService {
    public static final String SIMTIME_TOTAL = "SIMTIMETOTAL";
    protected static final Logger LOGGER = Logger.getLogger((String)SimulationDockServiceImpl.class.getName());
    private final BundleContext context;
    private final String myID = EcoreUtil.generateUUID();
    private ServiceTracker service;
    private final ServiceTracker eventService;
    private final EventAdmin eventAdmin;
    private DebugObserver debugObserver;
    Bundle simulationBundleRef = null;
    private DispatchingSimulationObserver simulationObservers = null;
    long simulationStartTime = -1L;

    public SimulationDockServiceImpl(BundleContext context) {
        this.context = context;
        ServiceReference eventServiceRef = context.getServiceReference(EventAdmin.class.getName());
        this.eventService = new ServiceTracker(context, eventServiceRef, null);
        this.eventService.open();
        this.eventAdmin = (EventAdmin)this.eventService.getService();
        LOGGER.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(), "System.out"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Simulation Dock Started");
        }
    }

    protected void finalize() throws Throwable {
        this.eventService.close();
        super.finalize();
    }

    @Override
    public void load(AbstractSimulationConfig config, byte[] simulationBundle, boolean isRemoteRun) {
        this.sendEvent("de/uka/ipd/sdq/simucomframework/simucomdock/DOCK_BUSY");
        this.debugObserver = config.isDebug() ? new DebugObserver(this.eventAdmin, this) : null;
        this.ensurePluginLoaded(this.context, "org.eclipse.equinox.event");
        this.unloadPluginIfExists(this.context, "de.uka.ipd.sdq.temporary");
        try {
            this.loadBundle(config, simulationBundle, this.eventAdmin, isRemoteRun);
        }
        catch (Exception e) {
            this.unloadPluginIfExists(this.context, "de.uka.ipd.sdq.temporary");
            this.sendEvent("de/uka/ipd/sdq/simucomframework/simucomdock/DOCK_IDLE");
            throw new RuntimeException("Simulation preparation failed", e);
        }
    }

    @Override
    public void simulate(AbstractSimulationConfig config, byte[] simulationBundle, boolean isRemoteRun) {
        try {
            try {
                this.simulateBundle(config, simulationBundle, this.eventAdmin, isRemoteRun);
            }
            catch (Exception e) {
                throw new RuntimeException("Simulation failed", e);
            }
        }
        finally {
            this.unloadPluginIfExists(this.context, "de.uka.ipd.sdq.temporary");
            this.sendEvent("de/uka/ipd/sdq/simucomframework/simucomdock/DOCK_IDLE");
        }
    }

    private void loadBundle(AbstractSimulationConfig config, byte[] simulationBundle, EventAdmin eventAdmin, boolean isRemoteRun) {
        String bundleLocation = this.persistBundleInTempDir(simulationBundle);
        try {
            this.simulationBundleRef = this.context.installBundle(new File(bundleLocation).toURI().toString());
            this.simulationBundleRef.start();
        }
        catch (BundleException e) {
            SimulationDockServiceImpl.uninstallBundle(this.simulationBundleRef);
            throw new RuntimeException("OSGi failure", e);
        }
        ServiceReference[] services = this.simulationBundleRef.getRegisteredServices();
        assert (services.length == 1);
        this.service = new ServiceTracker(this.context, services[0], null);
        this.service.open();
        try {
            this.simulationObservers = new DispatchingSimulationObserver();
            this.simulationObservers.addObserver(new SimulationProgressReportingObserver(config, eventAdmin, this));
            if (this.debugObserver != null) {
                this.simulationObservers.addObserver(this.debugObserver);
            }
            this.simulationStartTime = System.nanoTime();
            this.sendEvent("de/uka/ipd/sdq/simucomframework/simucomdock/SIM_STARTED");
            ((ISimulationControl)this.service.getService()).prepareSimulation(config, (IStatusObserver)this.simulationObservers, isRemoteRun);
        }
        catch (Exception ex) {
            SimulationDockServiceImpl.uninstallBundle(this.simulationBundleRef);
            throw new RuntimeException(ex);
        }
    }

    private static void uninstallBundle(Bundle simulationBundleRef) {
        if (simulationBundleRef != null) {
            try {
                simulationBundleRef.uninstall();
            }
            catch (BundleException e) {
                throw new RuntimeException("OSGi failure", e);
            }
        }
    }

    public SimuComModel getSimuComModel() {
        if (this.service != null) {
            IModelledApp abstractMain = (IModelledApp)this.service.getService();
            return abstractMain.getModel();
        }
        return null;
    }

    private void simulateBundle(AbstractSimulationConfig config, byte[] simulationBundle, EventAdmin eventAdmin, boolean isRemoteRun) {
        try {
            try {
                this.simulate(config, this.simulationBundleRef, eventAdmin, isRemoteRun);
            }
            catch (Exception e) {
                throw new RuntimeException("OSGi failure", e);
            }
        }
        finally {
            if (this.simulationBundleRef != null) {
                try {
                    if (this.simulationBundleRef.getState() == 32) {
                        this.simulationBundleRef.stop();
                    }
                    this.simulationBundleRef.uninstall();
                }
                catch (BundleException e) {
                    throw new RuntimeException("OSGi failure", e);
                }
            }
        }
    }

    private void simulate(AbstractSimulationConfig config, Bundle simulationBundleRef, EventAdmin eventAdmin, boolean isRemoteRun) {
        try {
            try {
                SimulationResult result = ((ISimulationControl)this.service.getService()).startSimulation(config, (IStatusObserver)this.simulationObservers, isRemoteRun);
                if (result == SimulationResult.ERROR) {
                    throw new RuntimeException("Simulation failed.", ((ISimulationControl)this.service.getService()).getErrorThrowable());
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.service.close();
            Hashtable<String, Long> eventData = new Hashtable<String, Long>();
            eventData.put(SIMTIME_TOTAL, System.nanoTime() - this.simulationStartTime);
            this.sendEvent("de/uka/ipd/sdq/simucomframework/simucomdock/SIM_STOPPED", eventData);
        }
    }

    @Override
    public void suspend() {
        if (this.debugObserver == null) {
            throw new IllegalStateException("Suspend only available in debug mode");
        }
        this.debugObserver.suspend();
    }

    @Override
    public void resume() {
        if (this.debugObserver == null) {
            throw new IllegalStateException("Suspend only available in debug mode");
        }
        this.debugObserver.resume();
    }

    private void sendEvent(String topic) {
        this.sendEvent(topic, new Hashtable());
    }

    private void sendEvent(String topic, Hashtable newProperties) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("DOCK_ID", this.getDockId());
        properties.putAll(newProperties);
        Event event = new Event(topic, properties);
        this.eventAdmin.sendEvent(event);
    }

    private String persistBundleInTempDir(byte[] simulationBundle) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("simucominstance", ".jar");
            tempFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(simulationBundle);
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("OSGi failure", e);
        }
        return tempFile.getAbsolutePath();
    }

    @Override
    public String getDockId() {
        return this.myID;
    }

    private void unloadPluginIfExists(BundleContext context, String bundleName) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName() != null && b.getSymbolicName().equals(bundleName)) {
                try {
                    if (b.getState() == 32) {
                        b.stop();
                    }
                    b.uninstall();
                }
                catch (BundleException e) {
                    throw new RuntimeException("OSGi failure", e);
                }
            }
            ++n2;
        }
    }

    private void ensurePluginLoaded(BundleContext context, String bundleName) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName() != null && b.getSymbolicName().equals(bundleName) && b.getState() != 32) {
                try {
                    b.start();
                }
                catch (BundleException e) {
                    throw new RuntimeException("OSGi failure", e);
                }
            }
            ++n2;
        }
    }

    @Override
    public void stopSimulation() {
        if (this.service != null && this.service.getService() != null) {
            ((ISimulationControl)this.service.getService()).stopSimulation();
        }
        if (this.debugObserver != null) {
            this.debugObserver.resume();
        }
    }

    @Override
    public void step() {
        if (this.debugObserver == null) {
            throw new IllegalStateException("Stepping only available in debug mode");
        }
        this.debugObserver.step();
    }

    @Override
    public SimuComStatus getSimuComStatus() {
        return ((ISimulationControl)this.service.getService()).getStatus();
    }
}

