/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables;

import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCacheEntry;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.StochasticExpressionEvaluationFailedException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.PCMStoExEvaluationVisitor;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.ecore.EObject;

public class StackContext
implements Serializable {
    private static final long serialVersionUID = 2031992603442903211L;
    private VariableMode mode = VariableMode.EXCEPTION_ON_NOT_FOUND;
    private static final Logger LOGGER = Logger.getLogger((String)StackContext.class.getName());
    protected SimulatedStack<Object> stack = new SimulatedStack();

    public <T> T evaluate(String string, Class<T> expectedType) {
        return StackContext.evaluateStatic(string, expectedType, this.stack.currentStackFrame(), this.mode);
    }

    public Object evaluate(String string) {
        return StackContext.evaluateStatic(string, this.stack.currentStackFrame(), this.mode);
    }

    public Object evaluate(String stoex, SimulatedStackframe<Object> currentFrame) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("About to evaluate " + stoex));
        }
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(cacheEntry, currentFrame, this.mode, StoExCache.singleton().getProbabilityFunctionFactory()).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Result " + result));
        }
        return result;
    }

    public static Object evaluateStatic(String stoex) {
        return StackContext.evaluateStatic(stoex, new SimulatedStackframe<Object>());
    }

    public static Object evaluateStatic(String stoex, SimulatedStackframe<Object> currentFrame) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("About to evaluate " + stoex));
        }
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(cacheEntry, currentFrame, VariableMode.EXCEPTION_ON_NOT_FOUND, StoExCache.singleton().getProbabilityFunctionFactory()).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Result " + result));
        }
        return result;
    }

    public static Object evaluateStatic(String stoex, SimulatedStackframe<Object> currentFrame, VariableMode mode) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("About to evaluate " + stoex));
        }
        StoExCacheEntry cacheEntry = StoExCache.singleton().getEntry(stoex);
        Object result = null;
        try {
            result = new PCMStoExEvaluationVisitor(cacheEntry, currentFrame, mode, StoExCache.singleton().getProbabilityFunctionFactory()).doSwitch((EObject)cacheEntry.getParsedExpression());
        }
        catch (Exception ex) {
            throw new StochasticExpressionEvaluationFailedException("Evaluation of expression " + stoex + " failed.", ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Result " + result));
        }
        return result;
    }

    public static <T> T evaluateStatic(String string, Class<T> expectedType) {
        return StackContext.evaluateStatic(string, expectedType, new SimulatedStackframe<Object>(), VariableMode.EXCEPTION_ON_NOT_FOUND);
    }

    public static <T> T evaluateStatic(String string, Class<T> expectedType, SimulatedStackframe<Object> frame) {
        return StackContext.evaluateStatic(string, expectedType, frame, VariableMode.EXCEPTION_ON_NOT_FOUND);
    }

    public static <T> T evaluateStatic(String string, Class<T> expectedType, SimulatedStackframe<Object> frame, VariableMode mode) {
        Object result = StackContext.evaluateStatic(string, frame, mode);
        if (expectedType.isInstance(result)) {
            return (T)result;
        }
        if (expectedType == Byte.class && result.getClass() == Character.class) {
            return (T)Byte.valueOf((byte)((Character)result).charValue());
        }
        if (expectedType == Character.class && result.getClass() == Byte.class) {
            return (T)Character.valueOf((char)((Byte)result).byteValue());
        }
        if (expectedType == Short.class) {
            if (result.getClass() == Byte.class) {
                return (T)Short.valueOf(((Byte)result).shortValue());
            }
            if (result.getClass() == Character.class) {
                return (T)Short.valueOf(Byte.valueOf((byte)((Character)result).charValue()).shortValue());
            }
        }
        if (expectedType == Integer.class) {
            if (result.getClass() == Byte.class) {
                return (T)Integer.valueOf(((Byte)result).intValue());
            }
            if (result.getClass() == Short.class) {
                return (T)Integer.valueOf(((Short)result).intValue());
            }
            if (result.getClass() == Character.class) {
                return (T)Integer.valueOf(Byte.valueOf((byte)((Character)result).charValue()).intValue());
            }
        }
        if (expectedType == Long.class) {
            if (result.getClass() == Byte.class) {
                return (T)Long.valueOf(((Byte)result).longValue());
            }
            if (result.getClass() == Short.class) {
                return (T)Long.valueOf(((Short)result).longValue());
            }
            if (result.getClass() == Integer.class) {
                return (T)Long.valueOf(((Integer)result).longValue());
            }
            if (result.getClass() == Character.class) {
                return (T)Long.valueOf(Byte.valueOf((byte)((Character)result).charValue()).longValue());
            }
        }
        if (expectedType == Float.class) {
            if (result.getClass() == Byte.class) {
                return (T)Float.valueOf(((Byte)result).floatValue());
            }
            if (result.getClass() == Short.class) {
                return (T)Float.valueOf(((Short)result).floatValue());
            }
            if (result.getClass() == Integer.class) {
                return (T)Float.valueOf(((Integer)result).floatValue());
            }
            if (result.getClass() == Long.class) {
                return (T)Float.valueOf(((Long)result).floatValue());
            }
            if (result.getClass() == Character.class) {
                return (T)Float.valueOf(Byte.valueOf((byte)((Character)result).charValue()).floatValue());
            }
        }
        if (expectedType == Double.class) {
            if (result.getClass() == Byte.class) {
                return (T)Double.valueOf(((Byte)result).doubleValue());
            }
            if (result.getClass() == Short.class) {
                return (T)Double.valueOf(((Short)result).doubleValue());
            }
            if (result.getClass() == Integer.class) {
                return (T)Double.valueOf(((Integer)result).doubleValue());
            }
            if (result.getClass() == Long.class) {
                return (T)Double.valueOf(((Long)result).doubleValue());
            }
            if (result.getClass() == Float.class) {
                return (T)Double.valueOf(((Float)result).doubleValue());
            }
            if (result.getClass() == Character.class) {
                return (T)Double.valueOf(Byte.valueOf((byte)((Character)result).charValue()).doubleValue());
            }
        }
        UnsupportedOperationException ex = new UnsupportedOperationException("Evaluation result is of type " + result.getClass().getCanonicalName() + " but expected was " + expectedType.getCanonicalName() + " and no conversion was available...");
        if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
            LOGGER.error((Object)"Evaluation of an expression resulted in wrong type!", (Throwable)ex);
        }
        throw ex;
    }

    public void evaluateInner(SimulatedStackframe<Object> frame, String variablename) {
        SimulatedStackframe<Object> topmostFrame = this.getStack().currentStackFrame();
        for (Map.Entry<String, Object> e : topmostFrame.getContents()) {
            if (!e.getKey().startsWith(variablename) || !(e.getValue() instanceof EvaluationProxy)) continue;
            EvaluationProxy proxy = (EvaluationProxy)e.getValue();
            Object result = StackContext.evaluateStatic(proxy.getStoEx(), proxy.getStackFrame(), this.mode);
            frame.addValue(e.getKey(), result);
        }
    }

    public SimulatedStack<Object> getStack() {
        return this.stack;
    }

    public VariableMode getEvaluationMode() {
        return this.mode;
    }

    public void setEvaluationMode(VariableMode mode) {
        this.mode = mode;
    }
}

