/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.probfunction.math.IGammaDistribution;
import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.functions.AbstractProbDistFunction;
import java.util.List;

public class GammaDistFunction
extends AbstractProbDistFunction {
    public GammaDistFunction(IRandomGenerator randomGen, IPDFFactory factory) {
        super(randomGen, factory);
    }

    @Override
    public boolean checkParameters(List<Object> parameters) {
        if (parameters.size() != 2) {
            return false;
        }
        if (NumberConverter.toDouble(parameters.get(1)) <= 0.0) {
            return false;
        }
        return !(NumberConverter.toDouble(parameters.get(0)) <= 0.0);
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        double alpha = NumberConverter.toDouble(parameters.get(0));
        double theta = NumberConverter.toDouble(parameters.get(1));
        IGammaDistribution distribution = this.factory.createGammaDistribution(alpha, theta);
        return distribution.inverseF(this.randomGen.random());
    }
}

