/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.cache;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunction;
import de.uka.ipd.sdq.simucomframework.variables.cache.ProbFunctionCache;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.text.ParseException;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.stoex.api.StoExParser;

public class StoExCacheEntry {
    private static final StoExParser STOEX_PARSER = StoExParser.createInstance();
    private final String spec;
    private final Expression parsedExpression;
    private final ExpressionInferTypeVisitor typeInferer;
    private final ProbFunctionCache probFunctionCache;

    public StoExCacheEntry(String spec) {
        this.spec = spec;
        Expression formula = null;
        try {
            formula = STOEX_PARSER.parse(spec);
        }
        catch (ParseException e) {
            throw new RuntimeException("Expression not parsable \"" + spec + "\"", e);
        }
        try {
            this.typeInferer = new NonProbabilisticExpressionInferTypeVisitor();
            this.typeInferer.doSwitch((EObject)formula);
        }
        catch (Exception e) {
            throw new RuntimeException("Expression not parsable \"" + spec + "\"", e);
        }
        this.parsedExpression = formula;
        this.probFunctionCache = new ProbFunctionCache(formula);
    }

    public Expression getParsedExpression() {
        return this.parsedExpression;
    }

    public String getSpec() {
        return this.spec;
    }

    public ExpressionInferTypeVisitor getTypeInferer() {
        return this.typeInferer;
    }

    public TypeEnum getInferedType(Expression e) {
        return this.typeInferer.getType(e);
    }

    public ProbFunctionCache getProbFunctionCache() {
        return this.probFunctionCache;
    }

    public IProbabilityFunction getProbFunction(EObject e) {
        assert (this.contains((Iterator<EObject>)this.getParsedExpression().eAllContents(), e));
        return this.probFunctionCache.getProbFunction(e);
    }

    private boolean contains(Iterator<EObject> i, EObject e) {
        while (i.hasNext()) {
            EObject n = i.next();
            if (n != e) continue;
            return true;
        }
        return false;
    }
}

