/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.accuracy;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import org.palladiosimulator.analyzer.accuracy.issues.AccuracyIssueFactory;

public class AccuracyAnalysisHelper {
    public static void checkBoundsInterval(String partitionId, String partitionResourceName, SimuComModel config, SimulatedStackframe<Object> stackframe, String simuComId, String rdseffId, String actionId, String resourceName, String from, String to) {
        Object value;
        try {
            value = stackframe.getValue(simuComId);
            if (value.getClass() == EvaluationProxy.class) {
                value = StackContext.evaluateStatic((String)((EvaluationProxy)value).getStoEx());
            }
        }
        catch (ValueNotInFrameException e) {
            config.addIssue(AccuracyIssueFactory.createCharacterisedPCMParameterPartition((String)("The partition referenced the variable " + simuComId + " which was not accessible during runtime. Correct the quality information or PCM model."), (String)partitionResourceName, (String)partitionId));
            return;
        }
        if (value instanceof Byte) {
            if ((Byte)value < (Byte)StackContext.evaluateStatic((String)from, Byte.class) || (Byte)value > (Byte)StackContext.evaluateStatic((String)to, Byte.class)) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Character) {
            if (((Character)value).charValue() < ((Character)StackContext.evaluateStatic((String)from, Character.class)).charValue() || ((Character)value).charValue() > ((Character)StackContext.evaluateStatic((String)to, Character.class)).charValue()) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Short) {
            if ((Short)value < (Short)StackContext.evaluateStatic((String)from, Short.class) || (Short)value > (Short)StackContext.evaluateStatic((String)to, Short.class)) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Integer) {
            if ((Integer)value < (Integer)StackContext.evaluateStatic((String)from, Integer.class) || (Integer)value > (Integer)StackContext.evaluateStatic((String)to, Integer.class)) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Long) {
            if ((Long)value < (Long)StackContext.evaluateStatic((String)from, Long.class) || (Long)value > (Long)StackContext.evaluateStatic((String)to, Long.class)) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Float) {
            if (!(((Float)value).floatValue() >= ((Float)StackContext.evaluateStatic((String)from, Float.class)).floatValue()) || !(((Float)value).floatValue() <= ((Float)StackContext.evaluateStatic((String)to, Float.class)).floatValue())) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else if (value instanceof Double) {
            if ((Double)value >= (Double)StackContext.evaluateStatic((String)from, Double.class) && (Double)value <= (Double)StackContext.evaluateStatic((String)to, Double.class)) {
                config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
            }
        } else {
            String msg = "The dynamic type for " + simuComId + " was " + value.getClass().getCanonicalName() + " which is not supported for interval-typed checks in accuracy influence analysis. Use CharacterisedPCMParameterPartitionRange if the value is not a numeric type.";
            config.addIssue(AccuracyIssueFactory.createTypeInferenceIssue((String)msg));
        }
    }

    public static void checkBoundsRange(String partitionId, String partitionResourceName, SimuComModel config, SimulatedStackframe<Object> stackframe, String simuComId, String rdseffId, String actionId, String resourceName, String ... specifications) {
        Object value;
        try {
            value = stackframe.getValue(simuComId);
            if (value.getClass() == EvaluationProxy.class) {
                value = StackContext.evaluateStatic((String)((EvaluationProxy)value).getStoEx());
            }
        }
        catch (ValueNotInFrameException e) {
            config.addIssue(AccuracyIssueFactory.createCharacterisedPCMParameterPartition((String)("The partition referenced the variable " + simuComId + " which was not accessible during runtime. Correct the quality information or PCM model."), (String)partitionResourceName, (String)partitionId));
            return;
        }
        Class<?> clazz = value.getClass();
        boolean found = false;
        String[] stringArray = specifications;
        int n = specifications.length;
        int n2 = 0;
        while (n2 < n) {
            String specification = stringArray[n2];
            if (StackContext.evaluateStatic((String)specification, clazz).equals(value)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            config.addIssue(AccuracyIssueFactory.createParameterExtrapolationIssue((String)simuComId, (String)rdseffId, (String)resourceName, (Object)value, (String)actionId));
        }
    }
}

