/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.preferences;

import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.util.AbstractSimEngineExtensionHelper;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class SimulationPreferencesHelper {
    private static final Logger LOGGER = Logger.getLogger(SimulationPreferencesHelper.class);

    public static String getDefaultEngineId() {
        String firstEngineId;
        block3: {
            firstEngineId = null;
            try {
                String[][] engineNamesAndIds = AbstractSimEngineExtensionHelper.getEngineNamesAndIds();
                if (engineNamesAndIds.length > 0) {
                    firstEngineId = engineNamesAndIds[0][1];
                }
            }
            catch (CoreException e) {
                if (!LOGGER.isEnabledFor((Priority)Level.WARN)) break block3;
                LOGGER.warn((Object)"Could not retrieve simulation engine names and ids.", (Throwable)e);
            }
        }
        return firstEngineId;
    }

    public static ISimEngineFactory getPreferredSimulationEngine() {
        String preferredEngineId = Platform.getPreferencesService().getString("de.uka.ipd.sdq.simulation", "simulationEngineField", SimulationPreferencesHelper.getDefaultEngineId(), null);
        ISimEngineFactory engineFactory = null;
        try {
            engineFactory = AbstractSimEngineExtensionHelper.getEngineFactory((String)preferredEngineId);
        }
        catch (CoreException e) {
            LOGGER.warn((Object)("Could not load preferred simulation engine " + preferredEngineId + "."), (Throwable)e);
            try {
                engineFactory = AbstractSimEngineExtensionHelper.getEngineFactory((String)SimulationPreferencesHelper.getDefaultEngineId());
            }
            catch (CoreException e2) {
                LOGGER.warn((Object)("Could not load default simulation engine " + SimulationPreferencesHelper.getDefaultEngineId() + "."), (Throwable)e2);
            }
        }
        return engineFactory;
    }
}

