/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics;

import de.uka.ipd.sdq.statistics.ABatchAlgorithm;
import de.uka.ipd.sdq.statistics.Batch;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class StaticBatchAlgorithm
extends ABatchAlgorithm {
    private final int batchSize;
    private final int minNumberOfBatches;
    private final List<Double> buffer;
    private static final Logger LOGGER = Logger.getLogger((String)"de.uka.ipd.sdq.statistics.StaticBatchAlgorithm.log");

    public StaticBatchAlgorithm(int batchSize, int minNumberOfBatches) {
        this.batchSize = batchSize;
        this.minNumberOfBatches = minNumberOfBatches;
        if (minNumberOfBatches > 0) {
            this.setValid(false);
        } else {
            this.setValid(true);
        }
        if (batchSize > 100000) {
            LOGGER.warn((Object)"Batch size is larger than 100 000, thus more than 700KB are needed to store intermediate values. Decrease batch size of you have memory problems, or ask the developers to implement a sliding mean calculation for the batchs.");
        }
        this.buffer = new LinkedList<Double>();
    }

    @Override
    public synchronized void offerSample(double value) {
        this.buffer.add(value);
        if (this.buffer.size() > this.batchSize) {
            int batchSize = this.buffer.size();
            double batchSum = 0.0;
            for (Double sample : this.buffer) {
                batchSum += sample.doubleValue();
            }
            this.batches.add(new Batch(batchSum, batchSize));
            if (!this.hasValidBatches() && this.minNumberOfBatches <= this.batches.size()) {
                this.setValid(true);
            }
            this.buffer.clear();
        }
    }
}

