/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;
import java.util.List;
import org.opt4j.core.Objective;

public class InsignificantSetQualityImprovementConfig
extends AbstractConfiguration {
    private List<ValueDifference> valueDifferences;
    private List<UnresolvedValueDifference> unresolvedValueDifferences;
    private Integer pastIterationNumber;

    public InsignificantSetQualityImprovementConfig() {
        super(TerminationCriteriaNames.INSIGNIFICANT_SET_QUALITY_IMPROVEMENT);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.INSIGNIFICANT_SET_QUALITY_IMPROVEMENT && this.valueDifferences != null && !this.valueDifferences.isEmpty() && this.pastIterationNumber != null;
    }

    public void setValueDifferences(List<ValueDifference> valueDifferences) throws InvalidConfigException {
        if (valueDifferences == null || valueDifferences.isEmpty()) {
            throw new InvalidConfigException("InsignificantSetQualityImprovementConfig.setMaximumValueDifferences: the supplied parameter should not be null or empty");
        }
        this.valueDifferences = valueDifferences;
    }

    public List<ValueDifference> getValueDifferences() {
        return this.valueDifferences;
    }

    public void setUnresolvedValueDifferences(List<UnresolvedValueDifference> unresolvedValueDifferences) {
        this.unresolvedValueDifferences = unresolvedValueDifferences;
    }

    public List<UnresolvedValueDifference> getUnresolvedValueDifferences() {
        return this.unresolvedValueDifferences;
    }

    public void setComparisionGenerations(int pastIterationNumber) throws InvalidConfigException {
        if (pastIterationNumber < 1) {
            throw new InvalidConfigException("InsignificantSetQualityImprovementConfig.setComparisionGenerations: The parameter indicates how many generations in the past the current value is going to be compared with and  must be at least 1.");
        }
        this.pastIterationNumber = pastIterationNumber;
    }

    public int getComparisionGenerations() {
        return this.pastIterationNumber;
    }

    public class UnresolvedValueDifference {
        public final String objective;
        public final Double averageImprovement;
        public final Double maxMinImprovement;

        public UnresolvedValueDifference(String objective, Double averageImprovement, Double maxMinImprovement) throws Exception {
            this.objective = objective;
            this.averageImprovement = averageImprovement;
            this.maxMinImprovement = maxMinImprovement;
        }
    }

    public class ValueDifference {
        public final Objective objective;
        public final Double averageImprovement;
        public final Double maxMinImprovement;

        public ValueDifference(Objective objective, Double averageImprovement, Double maxMinImprovement) throws InvalidConfigException {
            if (averageImprovement == null || objective == null || maxMinImprovement == null || averageImprovement < 0.0 || averageImprovement > 1.0 || maxMinImprovement < 0.0 || maxMinImprovement > 1.0) {
                throw new InvalidConfigException("ValueDifference.ValueDifference: None of the supplied parameters should be null and averageImprovement and maxMinimprovement must be a percentage values between 0 and 1");
            }
            this.objective = objective;
            this.averageImprovement = averageImprovement;
            this.maxMinImprovement = maxMinImprovement;
        }
    }
}

