/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.config.MinimalQualityCriteriaValueConfig;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.MinimalQualityCriteriaValueCriterion;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opt4j.common.archive.DefaultArchive;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;

public class MinimalQualityCriteriaValueCriterionTest {
    MinimalQualityCriteriaValueConfig mqcvconf;
    MinimalQualityCriteriaValueCriterion mqcvcrit;
    Archive archive = new DefaultArchive();
    Objectives o1 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o2 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o3 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o4 = new Objectives((DominationStrategy)new ParetoDomination());
    Objectives o5 = new Objectives((DominationStrategy)new ParetoDomination());
    MyIndividual i1 = new MyIndividual();
    MyIndividual i2 = new MyIndividual();
    MyIndividual i3 = new MyIndividual();
    MyIndividual i4 = new MyIndividual();
    MyIndividual i5 = new MyIndividual();
    Objective X = new Objective("X", Objective.Sign.MIN);
    Objective Y = new Objective("Y", Objective.Sign.MIN);

    @Before
    public void setUp() throws Exception {
        this.mqcvconf = new MinimalQualityCriteriaValueConfig();
        this.o1.add(this.X, 2);
        this.o1.add(this.Y, 6);
        this.o2.add(this.X, 4);
        this.o2.add(this.Y, 3);
        this.o3.add(this.X, 3);
        this.o3.add(this.Y, 1.5);
        this.o4.add(this.X, 4);
        this.o4.add(this.Y, 0.5);
        this.i1.setObjectives(this.o1);
        this.i2.setObjectives(this.o2);
        this.i3.setObjectives(this.o3);
        this.i4.setObjectives(this.o4);
        this.archive.add((Individual)this.i1);
        this.archive.add((Individual)this.i2);
        this.archive.add((Individual)this.i3);
        this.archive.add((Individual)this.i4);
        this.o5.add(this.X, 2);
        this.o5.add(this.Y, 0.6);
        this.i5.setObjectives(this.o5);
        this.mqcvconf.setNumberOfCandidatesToConform(3);
        HashMap configuredObjects = new HashMap();
        configuredObjects.put(this.X, (Value<?>)new DoubleValue(Double.valueOf(5.0)));
        configuredObjects.put(this.Y, (Value<?>)new DoubleValue(Double.valueOf(2.5)));
        this.mqcvconf.setObjectiveMinimalValues(configuredObjects);
        if (!this.mqcvconf.validateConfiguration()) {
            throw new Exception();
        }
    }

    @Test
    public void testNotEnoughConformingCandidates() {
        Population population = new Population();
        population.add((Individual)this.i1);
        this.mqcvcrit = new MinimalQualityCriteriaValueCriterion(this.mqcvconf, population, this.archive);
        this.mqcvcrit.evaluate(0, 0L);
        Assert.assertFalse((boolean)this.mqcvcrit.getEvaluationResult());
    }

    @Test
    public void testEnoughConformingCandidates() {
        Population population = new Population();
        population.add((Individual)this.i1);
        this.mqcvcrit = new MinimalQualityCriteriaValueCriterion(this.mqcvconf, population, this.archive);
        this.archive.remove((Object)this.i2);
        this.archive.add((Individual)this.i5);
        this.mqcvcrit.evaluate(0, 0L);
        Assert.assertTrue((boolean)this.mqcvcrit.getEvaluationResult());
    }

    public class MyIndividual
    extends Individual {
        public MyIndividual() {
            this.setIndividualStatusListeners(new HashSet());
        }
    }
}

