/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OutputTests {
    Tree outputTree;

    @Before
    public void setUp() throws Exception {
        this.outputTree = new Tree("Root", Node.NodeType.NON_SPECIFIC);
    }

    @Test
    public void testParentAndChildren() {
        Assert.assertFalse((boolean)this.outputTree.hasChildren());
        Assert.assertNull((Object)this.outputTree.getParent());
        Node child1 = this.outputTree.addChild("Child 1", Node.NodeType.NON_SPECIFIC);
        Assert.assertNotNull((Object)child1);
        Assert.assertTrue((boolean)this.outputTree.hasChildren());
        Assert.assertTrue((this.outputTree.getChildren().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((child1.getParent() == this.outputTree ? 1 : 0) != 0);
        this.outputTree.clearChildren();
        Assert.assertFalse((boolean)this.outputTree.hasChildren());
    }

    @Test
    public void testUpdateValue() {
        Assert.assertTrue((boolean)this.outputTree.getValue().equals("Root"));
        this.outputTree.updateValue("UpdatedRoot");
        Assert.assertTrue((boolean)this.outputTree.getValue().equals("UpdatedRoot"));
    }

    @Test
    public void testIsRoot() {
        Assert.assertTrue((boolean)this.outputTree.isRoot());
        Node child1 = this.outputTree.addChild("Child 1", Node.NodeType.NON_SPECIFIC);
        Assert.assertFalse((boolean)child1.isRoot());
    }
}

