/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.outputtree;

import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private List<Node> children = new ArrayList<Node>();
    protected Node parent;
    private String value;
    public NodeType type;

    protected Node(Node parent, String value, NodeType type) {
        this.parent = parent;
        this.value = value;
        this.type = type;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public Node addChild(String value, NodeType type) {
        Node newNode = new Node(this, value, type);
        this.children.add(newNode);
        return newNode;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void attachSubtree(Tree tree) {
        this.children.add(tree);
        tree.parent = this;
    }

    public void updateValue(String newValue) {
        this.value = newValue;
    }

    public NodeType getType() {
        return this.type;
    }

    public String toString() {
        return this.value;
    }

    public String subTreeToString(String treePrefix, int prefixOccurance) {
        StringBuilder prefix = new StringBuilder();
        int i = 0;
        while (i < prefixOccurance) {
            prefix.append(treePrefix);
            ++i;
        }
        String eol = System.getProperty("line.separator");
        if (this.hasChildren()) {
            StringBuilder sb = new StringBuilder(String.valueOf(prefix.toString()) + this.toString() + eol);
            for (Node n : this.getChildren()) {
                sb.append(n.subTreeToString(treePrefix, prefixOccurance + 1));
            }
            return sb.toString();
        }
        return String.valueOf(prefix.toString()) + this.toString() + eol;
    }

    public static enum NodeType {
        NON_SPECIFIC,
        MANAGER,
        TERMINATION_CRITERIA,
        PARAMETER,
        PARAMETER_GROUP,
        EXPRESSION,
        WARNING;

    }
}

