/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.extension;

import de.uka.ipd.sdq.workflow.launchconfig.extension.WorkflowConfigurationTabExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;

public class WorkflowConfigurationTabExtensionHelper {
    private static final Logger LOGGER = Logger.getLogger(WorkflowConfigurationTabExtensionHelper.class);
    private static final String WORKFLOW_EXTENSION_POINT_ID = "de.uka.ipd.sdq.workflow.tab.extension";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_RUNCONFIG_TAB = "runconfig_tab";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_PRIORITY = "priority";
    private static final String WORKFLOW_EXTENSION_POINT_ATTRIBUTE_WORKFLOW_ID = "workflow_id";

    public static List<WorkflowConfigurationTabExtension> getWorkflowExtensionsSortedByPriority(String workflowId) {
        List<WorkflowConfigurationTabExtension> extensions = WorkflowConfigurationTabExtensionHelper.getWorkflowExtensions(workflowId);
        Collections.sort(extensions, new Comparator<WorkflowConfigurationTabExtension>(){

            @Override
            public int compare(WorkflowConfigurationTabExtension workflowExtensionA, WorkflowConfigurationTabExtension workflowExtensionB) {
                if (workflowExtensionA.getPriority() < workflowExtensionB.getPriority()) {
                    return -1;
                }
                if (workflowExtensionA.getPriority() == workflowExtensionB.getPriority()) {
                    return 0;
                }
                return 1;
            }
        });
        return extensions;
    }

    public static List<WorkflowConfigurationTabExtension> getWorkflowExtensions(String workflowId) {
        ArrayList<WorkflowConfigurationTabExtension> extensions = new ArrayList<WorkflowConfigurationTabExtension>();
        IExtension[] registeredExtensions = WorkflowConfigurationTabExtensionHelper.getRegisteredWorkflowExtensions();
        if (registeredExtensions == null) {
            return extensions;
        }
        int i = 0;
        while (i < registeredExtensions.length) {
            IExtension registeredExtension = registeredExtensions[i];
            IConfigurationElement[] elements = registeredExtension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block10: {
                    IConfigurationElement element = elements[j];
                    String workflowIdString = element.getAttribute(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_WORKFLOW_ID);
                    if (workflowIdString != null && workflowIdString.equals(workflowId)) {
                        String priorityString;
                        WorkflowConfigurationTabExtension extension;
                        block9: {
                            extension = new WorkflowConfigurationTabExtension(registeredExtension.getUniqueIdentifier(), workflowId);
                            try {
                                Object o = element.createExecutableExtension(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_RUNCONFIG_TAB);
                                if (o == null || !(o instanceof AbstractLaunchConfigurationTab)) break block9;
                                extension.setLaunchConfigurationTab((AbstractLaunchConfigurationTab)o);
                            }
                            catch (CoreException e) {
                                LOGGER.error((Object)"Unable to load config tab extension", (Throwable)e);
                                break block10;
                            }
                        }
                        if ((priorityString = element.getAttribute(WORKFLOW_EXTENSION_POINT_ATTRIBUTE_PRIORITY)) != null) {
                            try {
                                extension.setPriority(Integer.parseInt(priorityString));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error((Object)"Unable to load config tab extension priority", (Throwable)e);
                                break block10;
                            }
                        }
                        extensions.add(extension);
                    }
                }
                ++j;
            }
            ++i;
        }
        return extensions;
    }

    private static IExtension[] getRegisteredWorkflowExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(WORKFLOW_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        return extensions;
    }
}

