/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.multiple;

import de.uka.ipd.sdq.workflow.launchconfig.multiple.LaunchMultipleTab;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class LaunchMultiple
implements ILaunchConfigurationDelegate {
    private static final Logger LOGGER = Logger.getLogger(LaunchMultiple.class);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        List selectedLaunchConfigs = configuration.getAttribute("selected.launches", new LinkedList());
        LaunchMultipleTab tab = new LaunchMultipleTab();
        List<ILaunchConfiguration> availableLaunchconfis = tab.getLaunchConfigs();
        ArrayList<ILaunchConfiguration> configsToBeLaunched = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration launchConfiguration : availableLaunchconfis) {
            if (!selectedLaunchConfigs.contains(launchConfiguration.getName())) continue;
            configsToBeLaunched.add(launchConfiguration);
        }
        this.executeLaunchConfigurations(mode, launch, monitor, configsToBeLaunched);
    }

    private void executeLaunchConfigurations(String mode, ILaunch launch, IProgressMonitor monitor, List<ILaunchConfiguration> configsToBeLaunched) {
        for (ILaunchConfiguration launchConfiguration : configsToBeLaunched) {
            try {
                HashSet<String> modes = new HashSet<String>();
                modes.add(mode);
                ILaunchConfigurationDelegate delegate = launchConfiguration.getType().getDelegates(modes)[0].getDelegate();
                delegate.launch(launchConfiguration, mode, launch, monitor);
            }
            catch (Exception e) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Running " + launchConfiguration.getName() + " failed. I will start the next one. Cause: " + e.getMessage()));
                }
                e.printStackTrace();
            }
        }
    }
}

