/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.multiple;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LaunchMultipleTab
extends AbstractLaunchConfigurationTab {
    public static final String SELECTED_LAUNCHES = "selected.launches";
    private static final int NUMBER_OF_COLUMNS = 1;
    private static final String CONFIG_TYPE_ID = "de.uka.ipd.sdq.workflow.launchconfig.multiple.launchMultipleType";
    private List<Button> buttons = new ArrayList<Button>();
    private static final Logger LOGGER = Logger.getLogger(LaunchMultipleTab.class);

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        Group loggingGroup = new Group(container, 4);
        loggingGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        loggingGroup.setText("Choose Launch Configs to run.");
        loggingGroup.setLayout((Layout)layout);
        this.buttons = new ArrayList<Button>();
        List<ILaunchConfiguration> configs = this.getLaunchConfigs();
        for (ILaunchConfiguration launchConfiguration : configs) {
            this.buttons.add(this.createCheckBox(launchConfiguration, loggingGroup));
        }
    }

    public List<ILaunchConfiguration> getLaunchConfigs() {
        ILaunchConfigurationType[] launchTypes;
        ILaunchManager manager = this.getLaunchManager();
        LinkedList<ILaunchConfiguration> allTypes = new LinkedList<ILaunchConfiguration>();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = launchTypes = manager.getLaunchConfigurationTypes();
        int n = launchTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType launchType = iLaunchConfigurationTypeArray[n2];
            try {
                if (!launchType.getIdentifier().equals(CONFIG_TYPE_ID)) {
                    ILaunchConfiguration[] configs = null;
                    ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(launchType);
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n4];
                        allTypes.add(iLaunchConfiguration);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Could not find a configuration type for id " + launchType.getIdentifier() + ", skipping it."));
                }
                e.printStackTrace();
            }
            ++n2;
        }
        return allTypes;
    }

    private Button createCheckBox(ILaunchConfiguration launchConfiguration, Group launchConfigGroup) {
        Button launchConfigButton = new Button((Composite)launchConfigGroup, 32);
        launchConfigButton.setText(launchConfiguration.getName());
        launchConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchMultipleTab.this.updateLaunchConfigurationDialog();
            }
        });
        launchConfigButton.setSelection(false);
        return launchConfigButton;
    }

    public String getName() {
        return "Launch Multiple Runs Tab";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List selectedLaunchConfigs = configuration.getAttribute(SELECTED_LAUNCHES, new LinkedList());
            for (String configName : selectedLaunchConfigs) {
                Button button = this.getButtonFor(configName);
                if (button == null) continue;
                button.setSelection(true);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private Button getButtonFor(String name) {
        for (Button button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            return button;
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        LinkedList<String> selectedConfigs = new LinkedList<String>();
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            selectedConfigs.add(button.getText());
        }
        config.setAttribute(SELECTED_LAUNCHES, selectedConfigs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        for (Button button : this.buttons) {
            config.setAttribute(button.getText(), true);
        }
    }
}

