/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.core.SeverityEnum;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

public class CheckEMFConstraintsJob
extends ModelValidationJob {
    private MDSDBlackboard blackboard;
    private final String partitionName;

    public CheckEMFConstraintsJob(SeverityEnum errorLevel, String partitionName) {
        super(errorLevel);
        this.partitionName = partitionName;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ArrayList<SeverityAndIssue> result = new ArrayList<SeverityAndIssue>();
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.partitionName);
        partition.resolveAllProxies();
        for (Resource r : partition.getResourceSet().getResources()) {
            EList contents = r.getContents();
            if (contents == null || contents.size() == 0) {
                BasicDiagnostic d = new BasicDiagnostic(4, this.getClass().getCanonicalName(), 0, "Requested file " + r.getURI() + " cannot be loaded. Make sure it exists and is valid, or fix your model's references.", new Object[1]);
                this.appendSeverityAndIssueFromDiagnostic(result, (Diagnostic)d, SeverityEnum.ERROR);
                continue;
            }
            Diagnostician diagnostician = new Diagnostician();
            Diagnostic d = diagnostician.validate((EObject)contents.get(0));
            this.appendSeverityAndIssueFromDiagnostic(result, d);
        }
        this.setJobResult(result);
    }

    public String getName() {
        return "Check EMF Model Constraints";
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    private void appendSeverityAndIssueFromDiagnostic(ArrayList<SeverityAndIssue> result, Diagnostic d, SeverityEnum severity) {
        if (d.getSeverity() >= 4) {
            SeverityAndIssue sai = new SeverityAndIssue(severity, d.getMessage(), (EObject)d.getData().get(0));
            result.add(sai);
        }
        for (Diagnostic child : d.getChildren()) {
            this.appendSeverityAndIssueFromDiagnostic(result, child);
        }
    }

    private void appendSeverityAndIssueFromDiagnostic(ArrayList<SeverityAndIssue> result, Diagnostic d) {
        this.appendSeverityAndIssueFromDiagnostic(result, d, this.getErrorLevel());
    }
}

