/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.designdecision;

import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.FeatureCompletion;
import FeatureCompletionModel.PerimeterProviding;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.specificFactory;
import featureObjective.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.system.System;

public class FCCAllocDegreeDesignDecision {
    private final System system;
    private final FeatureCompletion featureCompletion;

    public FCCAllocDegreeDesignDecision(FeatureCompletion featureCompletion, System system) {
        this.featureCompletion = featureCompletion;
        this.system = system;
    }

    public List<ClassChoice> getFCCClassChoicesFrom(List<ResourceContainer> availableResourceContainer) {
        List<CompletionComponent> fccs = this.getUsedFCCs();
        ArrayList<ClassChoice> choices = new ArrayList<ClassChoice>();
        for (CompletionComponent fcc : fccs) {
            ClassChoice c = this.toClassChoice(fcc, availableResourceContainer);
            choices.add(c);
        }
        return choices;
    }

    private List<Feature> getAllUsedFeatures() {
        HashSet<Feature> allFeatures = new HashSet<Feature>();
        for (Connector assembly : this.system.getConnectors__ComposedStructure()) {
            List cvs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)assembly, ComplementumVisnetis.class);
            for (ComplementumVisnetis cv : cvs) {
                if (cv.getComplementaryFeature() == null) continue;
                allFeatures.add(cv.getComplementaryFeature());
            }
        }
        return new ArrayList<Feature>(allFeatures);
    }

    private List<CompletionComponent> getUsedFCCs() {
        List<Feature> allUsedFeatures = this.getAllUsedFeatures();
        HashSet<CompletionComponent> usedFCCs = new HashSet<CompletionComponent>();
        for (CompletionComponent c : this.featureCompletion.getCompletionComponents()) {
            PerimeterProviding pp = c.getPerimeterProviding();
            if (pp == null) continue;
            for (Feature ppf : pp.getFeatureProviding()) {
                if (!allUsedFeatures.contains(ppf)) continue;
                usedFCCs.add(c);
            }
        }
        LinkedList queue = new LinkedList(usedFCCs);
        usedFCCs.clear();
        while (!queue.isEmpty()) {
            CompletionComponent currentC = (CompletionComponent)queue.poll();
            if (!usedFCCs.add(currentC)) continue;
            queue.addAll(currentC.getRequiredComponents());
        }
        return new ArrayList<CompletionComponent>(usedFCCs);
    }

    private AllocationDegree createAllocationDegreeWith(CompletionComponent fcc, List<ResourceContainer> availableResourceContainer) {
        AllocationDegree allocDegree = specificFactory.eINSTANCE.createAllocationDegree();
        allocDegree.setPrimaryChanged((EObject)fcc);
        allocDegree.getClassDesignOptions().addAll(availableResourceContainer);
        return allocDegree;
    }

    private ClassChoice toClassChoice(CompletionComponent fcc, List<ResourceContainer> availableResourceContainer) {
        AllocationDegree allocDegree = this.createAllocationDegreeWith(fcc, availableResourceContainer);
        ClassChoice choice = this.createClassChoiceWith(allocDegree);
        return this.deployOnRandomResourceContainer(choice, availableResourceContainer);
    }

    private ClassChoice createClassChoiceWith(AllocationDegree allocDegree) {
        ClassChoice choice = designdecisionFactory.eINSTANCE.createClassChoice();
        choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)allocDegree);
        return choice;
    }

    private ClassChoice deployOnRandomResourceContainer(ClassChoice choice, List<ResourceContainer> availableResourceContainer) {
        choice.setChosenValue((EObject)availableResourceContainer.get(0));
        return choice;
    }
}

