/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver;

import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.FeatureCompletion;
import FeatureCompletionModel.FeatureCompletionPackage;
import FeatureCompletionModel.FeatureCompletionRepository;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import de.uka.ipd.sdq.pcm.cost.CostRepository;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.FeatureCompletionDegree;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUnweaver;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.IWeavingStrategy;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingLocation;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingStrategies;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util.LocationExtractor;
import featureSolution.InclusionMechanism;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.solver.core.models.PCMInstance;

public final class FCCWeaver {
    public static final String ADAPTER_NAME = "Adapter";
    public static final String CONCERN_REPOSITORY_NAME = "TemporaryConcernRepository";
    public static final String CONCERN_REPSITORY_DESCRIPTION = "Include components of all reused concerns.";
    private final List<Repository> solutions;
    private final FeatureCompletion fc;
    private final InclusionMechanism im;
    private final System initialSystem;
    private final PCMResourceSetPartition initialPartition;
    private final List<Pair<String, ComplementumVisnetis>> availableCVs;
    private final FCCUnweaver unweaver;
    private Choice fccChoice;
    private List<Choice> allocationChoices;
    private IWeavingStrategy strategy;

    public FCCWeaver(MDSDBlackboard blackboard, List<Repository> solutions, CostRepository costModel) {
        PCMResourceSetPartition initial;
        this.solutions = solutions;
        this.initialPartition = initial = (PCMResourceSetPartition)blackboard.getPartition("initialPCModelPartitionID");
        this.initialSystem = initial.getSystem();
        this.fc = this.determineFC(initial);
        this.im = this.determineIM(this.solutions);
        this.availableCVs = this.extractAvailableCVs(initial.getSystem());
        this.unweaver = new FCCUnweaver(blackboard);
    }

    private FeatureCompletion determineFC(PCMResourceSetPartition initialPartition) {
        List fcrs = initialPartition.getElement(FeatureCompletionPackage.eINSTANCE.getFeatureCompletionRepository());
        if (fcrs == null || fcrs.size() != 1) {
            return null;
        }
        FeatureCompletionRepository fcr = (FeatureCompletionRepository)fcrs.get(0);
        EList fcl = fcr.getFeatureCompletions();
        if (fcl == null || fcl.size() != 1) {
            return null;
        }
        return (FeatureCompletion)fcl.get(0);
    }

    public void nextDecodeStart() {
        this.fccChoice = null;
        this.allocationChoices = new ArrayList<Choice>();
        WeavingStrategies.getStrategy(this.im).getExtension().nextDecodeStart();
    }

    public void grabChoices(List<Choice> notTransformedChoices) {
        for (Choice c : notTransformedChoices) {
            if (c.getDegreeOfFreedomInstance() instanceof FeatureCompletionDegree) {
                this.fccChoice = c;
                continue;
            }
            if (!(c.getDegreeOfFreedomInstance() instanceof AllocationDegree)) continue;
            this.addAllocationDegreeIfNeeded(c);
        }
        notTransformedChoices.remove(this.fccChoice);
        for (Choice ac : this.allocationChoices) {
            notTransformedChoices.remove(ac);
        }
        this.determineStrategy(this.im).getExtension().grabChoices(this.fccChoice, notTransformedChoices);
    }

    private void addAllocationDegreeIfNeeded(Choice ac) {
        boolean hasFCC = this.isAllocationDegreeWithFCC(ac.getDegreeOfFreedomInstance());
        if (!hasFCC) {
            return;
        }
        this.allocationChoices.add(ac);
    }

    private boolean isAllocationDegreeWithFCC(DegreeOfFreedomInstance degreeOfFreedomInstance) {
        return degreeOfFreedomInstance instanceof AllocationDegree && degreeOfFreedomInstance.getPrimaryChanged() instanceof CompletionComponent;
    }

    public PCMInstance getWeavedInstance(PCMInstance pcmToAdopt) {
        this.unweaver.unweave(pcmToAdopt, this.availableCVs);
        Repository solution = (Repository)this.fccChoice.getValue();
        WeavingStrategies.Constructor strategyContructor = this.determineStrategy(this.im).getConstructor();
        List<Pair<ComplementumVisnetis, WeavingLocation>> locations = this.determineLocations(pcmToAdopt);
        this.strategy = strategyContructor.create(pcmToAdopt, solution, this.fc, this.im);
        this.strategy.initialize(locations, this.fccChoice, this.allocationChoices);
        this.strategy.weave();
        return pcmToAdopt;
    }

    public List<Choice> getConvertedFCCClassChoices() {
        return this.strategy.getConvertedFCCClassChoices();
    }

    private List<Pair<ComplementumVisnetis, WeavingLocation>> determineLocations(PCMInstance original) {
        ArrayList<Pair<ComplementumVisnetis, WeavingLocation>> result = new ArrayList<Pair<ComplementumVisnetis, WeavingLocation>>();
        System pcmSystem = original.getSystem();
        for (Pair<String, ComplementumVisnetis> connector : this.availableCVs) {
            List<WeavingLocation> location = LocationExtractor.extractLocation(connector, original);
            result.addAll(this.getPairs((Pair<Connector, ComplementumVisnetis>)Pair.of((Object)FCCWeaver.getConnectorBy(pcmSystem, (String)connector.first), (Object)((ComplementumVisnetis)connector.second)), location));
        }
        return result;
    }

    private static Connector getConnectorBy(System pcmSystem, String connectorID) {
        for (Connector connector : pcmSystem.getConnectors__ComposedStructure()) {
            if (!connector.getId().equals(connectorID)) continue;
            return connector;
        }
        return null;
    }

    private Collection<? extends Pair<ComplementumVisnetis, WeavingLocation>> getPairs(Pair<Connector, ComplementumVisnetis> connector, List<WeavingLocation> locations) {
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (WeavingLocation location : locations) {
            result.add(Pair.of((Object)((ComplementumVisnetis)connector.second), (Object)location));
        }
        return result;
    }

    private List<Pair<String, ComplementumVisnetis>> extractAvailableCVs(System pcmSystem) {
        ArrayList<Pair<String, ComplementumVisnetis>> result = new ArrayList<Pair<String, ComplementumVisnetis>>();
        for (Connector c : pcmSystem.getConnectors__ComposedStructure()) {
            List cv = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)c, ComplementumVisnetis.class, (String)"target");
            if (cv.isEmpty()) continue;
            result.add((Pair<String, ComplementumVisnetis>)Pair.of((Object)c.getId(), (Object)((ComplementumVisnetis)cv.get(0))));
        }
        return result;
    }

    public List<Repository> getSolutionRepositories() {
        return this.solutions;
    }

    public InclusionMechanism getInclusionMechanism() {
        return this.im;
    }

    private InclusionMechanism determineIM(List<Repository> solutions) {
        InclusionMechanism meachanism = null;
        for (Repository repo : solutions) {
            List meachanisms = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)repo, InclusionMechanism.class, (String)"transformation");
            if (meachanisms.size() != 1) continue;
            if (meachanism == null) {
                meachanism = (InclusionMechanism)meachanisms.get(0);
                continue;
            }
            if (meachanism.getId().equals(((InclusionMechanism)meachanisms.get(0)).getId())) continue;
            throw new FCCWeaverException("Multiple InclusionMechanisms are not supported yet.");
        }
        return meachanism;
    }

    private WeavingStrategies determineStrategy(InclusionMechanism im) {
        WeavingStrategies strategy = WeavingStrategies.getStrategy(im);
        if (strategy == null) {
            throw new FCCWeaverException("No Strategy found for " + im);
        }
        return strategy;
    }

    public System getInitialSystem() {
        return this.initialSystem;
    }

    public PCMResourceSetPartition getInitialPartition() {
        return this.initialPartition;
    }
}

