/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour;

import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.FeatureCompletion;
import FeatureCompletionModel.PlacementPolicy;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.pcm.designdecision.BoolChoice;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.impl.specificFactoryImpl;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCModule;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.IWeavingStrategy;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingLocation;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingStrategies;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.AllocationWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.AssemblyWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.BehaviourStrategyExtension;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.BehaviourWeavingFactory;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.BehaviourWeavingInstruction;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IBehaviourWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IWeavingInstruction;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IWeavingLocation;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.RepositoryWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.ServiceEffectSpecificationWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.util.BehaviourInclusionInstructionGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FCCFeatureHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FCCStructureHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmAllocationManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmServiceEffectSpecificationManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmSystemManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmUsageModelManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.SolutionManager;
import featureSolution.BehaviourInclusion;
import featureSolution.InclusionMechanism;
import featureSolution.impl.BehaviourInclusionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.EMFHelper;
import placementDescription.Advice;
import placementDescription.PlacementStrategy;
import placementDescription.PointCut;
import placementDescription.SelectedCV;
import placementDescription.impl.ControlFlowPlacementStrategyImpl;
import placementDescription.impl.ExternalCallPlacementStrategyImpl;
import placementDescription.impl.InternalActionPlacementStrategyImpl;

public class BehaviourWeavingStrategy
implements IWeavingStrategy,
IBehaviourWeaving {
    private final PCMInstance pcmToAdapt;
    private final Repository solution;
    private final FeatureCompletion fc;
    private final InclusionMechanism im;
    private SolutionManager mrm;
    private PcmAllocationManager pam;
    private PcmServiceEffectSpecificationManager pseffm;
    private PcmSystemManager psm;
    private PcmUsageModelManager pumm;
    private List<IWeavingInstruction> instructions;
    private List<Choice> allocationChoices;
    private Choice multipleInclusionChoice;
    private List<Choice> advicePlacementChoices;
    private List<Choice> cvChoices;
    private List<ComplementumVisnetis> selectedCVs;

    public BehaviourWeavingStrategy(PCMInstance pcmToAdapt, Repository solution, FeatureCompletion fc, InclusionMechanism im) {
        this.pcmToAdapt = pcmToAdapt;
        this.solution = solution;
        this.fc = fc;
        this.im = im;
        this.initManagers();
    }

    private void initManagers() {
        this.mrm = new SolutionManager(this.solution);
        this.pam = new PcmAllocationManager(this.pcmToAdapt.getAllocation());
        this.pseffm = new PcmServiceEffectSpecificationManager();
        this.psm = new PcmSystemManager(this.pcmToAdapt.getSystem());
        this.pumm = new PcmUsageModelManager(this.pcmToAdapt.getUsageModel());
    }

    @Override
    public PCMInstance getPCMToAdapt() {
        return this.pcmToAdapt;
    }

    @Override
    public SolutionManager getMergedRepoManager() {
        return this.mrm;
    }

    @Override
    public PcmAllocationManager getPCMAllocationManager() {
        return this.pam;
    }

    @Override
    public PcmServiceEffectSpecificationManager getPCMSEFFManager() {
        return this.pseffm;
    }

    @Override
    public PcmSystemManager getPCMSystemManager() {
        return this.psm;
    }

    @Override
    public PcmUsageModelManager getPCMUsageModelManager() {
        return this.pumm;
    }

    @Override
    public void initialize(List<Pair<ComplementumVisnetis, WeavingLocation>> locations, Choice solutionChoice, List<Choice> allocationChoices) {
        FCCModule.LOGGER.debug((Object)"Initializing Behaviour Weaving Strategy");
        BehaviourStrategyExtension ese = (BehaviourStrategyExtension)WeavingStrategies.BEHAVIOUR.getExtension();
        this.allocationChoices = allocationChoices;
        this.multipleInclusionChoice = ese.multipleInclusionChoice;
        this.advicePlacementChoices = ese.advicePlacementChoices;
        this.cvChoices = ese.cvChoices;
        if (this.multipleInclusionChoice != null) {
            this.im.setMultiple(((BoolChoice)this.multipleInclusionChoice).isChosenValue());
        } else {
            this.im.setMultiple(false);
        }
        this.setSelectedCVs();
        List<IWeavingInstruction> instructions = this.determineInstructions();
        this.instructions = instructions;
        FCCModule.LOGGER.debug((Object)("Initialized " + instructions.size() + " instructions with " + instructions.stream().flatMap(instr -> instr.getWeavingLocations().stream()).count() + " weaving locations"));
    }

    private void setSelectedCVs() {
        this.selectedCVs = this.cvChoices.stream().map(choice -> ((SelectedCV)choice.getValue()).getComplementumVisnetis()).collect(Collectors.toList());
    }

    private List<Advice> getSelectedAdvices() {
        List<Advice> selectedAdvices = this.advicePlacementChoices.stream().filter(choice -> ((BoolChoice)choice).isChosenValue()).map(choice -> (Advice)choice.getDegreeOfFreedomInstance().getPrimaryChanged()).collect(Collectors.toList());
        selectedAdvices.addAll(((BehaviourInclusion)this.im).getAdvice().stream().filter(advice -> advice.getPlacementPolicy() == PlacementPolicy.MANDATORY).collect(Collectors.toList()));
        return selectedAdvices;
    }

    private List<IWeavingInstruction> determineInstructions() {
        FCCModule.LOGGER.debug((Object)"Behaviour Weaving Strategy: Determine Weaving Locations");
        ArrayList<IWeavingInstruction> instructions = new ArrayList<IWeavingInstruction>();
        BehaviourInclusionImpl behaviourIncl = (BehaviourInclusionImpl)this.im;
        BehaviourInclusionInstructionGenerator ig = new BehaviourInclusionInstructionGenerator(this.psm, new FCCFeatureHandler(this.mrm));
        for (Advice advice : this.getSelectedAdvices()) {
            PointCut pointCut = advice.getPointCut();
            PlacementStrategy placementStrategy = pointCut.getPlacementStrategy();
            ArrayList<IWeavingLocation> locations = new ArrayList<IWeavingLocation>();
            if (placementStrategy instanceof ExternalCallPlacementStrategyImpl) {
                locations.addAll(ig.generateExternalCallWeavingLocations((ExternalCallPlacementStrategyImpl)placementStrategy));
            } else if (placementStrategy instanceof InternalActionPlacementStrategyImpl) {
                locations.addAll(ig.generateInternalActionWeavingLocations((InternalActionPlacementStrategyImpl)placementStrategy));
            } else if (placementStrategy instanceof ControlFlowPlacementStrategyImpl) {
                locations.addAll(ig.generateControlFlowWeavingLocations((ControlFlowPlacementStrategyImpl)placementStrategy));
            }
            CompletionComponent completionComponent = new FCCFeatureHandler(this.mrm).getPerimeterProvidingFCCFor(this.selectedCVs, this.fc);
            List<OperationSignature> providedRoles = new FCCFeatureHandler(this.mrm).getPerimeterProvidedRolesFor(completionComponent, this.selectedCVs, this.fc);
            Pair pair = new Pair((Object)completionComponent, providedRoles);
            instructions.add(new BehaviourWeavingInstruction((Pair<CompletionComponent, List<OperationSignature>>)pair, advice, locations, (InclusionMechanism)behaviourIncl));
        }
        return instructions;
    }

    @Override
    public void weave() throws FCCWeaverException {
        FCCModule.LOGGER.debug((Object)"Behaviour Weaving Strategy: Start Weaving");
        AllocationWeaving allocationWeaving = new AllocationWeaving(this);
        AssemblyWeaving assemblyWeaving = new AssemblyWeaving(this);
        RepositoryWeaving repositoryWeaving = new RepositoryWeaving(this);
        for (IWeavingInstruction instruction : this.instructions) {
            ServiceEffectSpecificationWeaving seffWeaving = BehaviourWeavingFactory.getBehaviourSeffWeaverBy(instruction.getAdvice().getPointCut().getPlacementStrategy()).apply(this);
            repositoryWeaving.weave(instruction);
            seffWeaving.weave(instruction);
            assemblyWeaving.weave(instruction);
            allocationWeaving.weave(instruction);
        }
        FCCModule.LOGGER.debug((Object)"Behaviour Weaving Strategy: Weaving Finished");
    }

    public static void savePcmInstanceToFile(PCMInstance pcmInstance, String filePath) {
        BehaviourWeavingStrategy.saveToXMIFile(BehaviourWeavingStrategy.copyOf((EObject)pcmInstance.getAllocation()), String.valueOf(filePath) + ".allocation");
        List repositories = pcmInstance.getRepositories();
        for (Repository repository : repositories) {
            BehaviourWeavingStrategy.saveToXMIFile(BehaviourWeavingStrategy.copyOf((EObject)repository), String.valueOf(filePath) + "_" + repository.getEntityName() + ".repository");
        }
        BehaviourWeavingStrategy.saveToXMIFile(BehaviourWeavingStrategy.copyOf((EObject)pcmInstance.getSystem()), String.valueOf(filePath) + ".system");
        BehaviourWeavingStrategy.saveToXMIFile(BehaviourWeavingStrategy.copyOf((EObject)pcmInstance.getUsageModel()), String.valueOf(filePath) + ".usagemodel");
    }

    public static void saveToXMIFile(EObject modelToSave, String fileName) {
        EMFHelper.saveToXMIFile((EObject)modelToSave, (String)fileName);
    }

    private static EObject copyOf(EObject obj) {
        return obj;
    }

    @Override
    public List<Choice> getConvertedFCCClassChoices() {
        ArrayList<Choice> allocChoices = new ArrayList<Choice>();
        for (Choice fccClassChoice : this.allocationChoices) {
            CompletionComponent fcc = (CompletionComponent)fccClassChoice.getDegreeOfFreedomInstance().getPrimaryChanged();
            AssemblyContext assemblyContext = new FCCStructureHandler(fcc, this.mrm).getComponentsIntantiatingFCC(fcc, this.psm.getAssemblyContextsBy(context -> true));
            try {
                AllocationContext alloc = this.getPCMAllocationManager().getAllocationContextBy(ac -> ac.getAssemblyContext_AllocationContext().getId().equals(assemblyContext.getId())).get();
                AllocationDegree ad = specificFactoryImpl.init().createAllocationDegree();
                ad.setPrimaryChanged((EObject)alloc);
                ClassChoice choice = designdecisionFactoryImpl.init().createClassChoice();
                choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)ad);
                choice.setChosenValue(((ClassChoice)fccClassChoice).getChosenValue());
                allocChoices.add((Choice)choice);
            }
            catch (Exception e) {
                FCCModule.LOGGER.warn((Object)e.getMessage());
            }
        }
        return allocChoices;
    }

    @Override
    public List<ComplementumVisnetis> getSelectedCVs() {
        return this.selectedCVs;
    }
}

