/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.ErrorMessage;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class PcmAllocationManager {
    private Allocation allocation;

    public PcmAllocationManager(Allocation allocation) {
        this.allocation = allocation;
    }

    public Optional<AllocationContext> getAllocationContextBy(Predicate<AllocationContext> searchCriteria) {
        for (AllocationContext ac : this.getAllAllocationContexts()) {
            if (!searchCriteria.test(ac)) continue;
            return Optional.of(ac);
        }
        return Optional.empty();
    }

    private List<AllocationContext> getAllAllocationContexts() {
        return this.allocation.getAllocationContexts_Allocation();
    }

    public AllocationContext getAllocationContextContaining(RepositoryComponent allocatedComponent) throws FCCWeaverException {
        List<AllocationContext> allocs = this.getAllocationContextsAllocating(allocatedComponent);
        if (allocs.size() != 1) {
            throw new FCCWeaverException(ErrorMessage.allocationError(allocatedComponent, allocs.size()));
        }
        return allocs.get(0);
    }

    private List<AllocationContext> getAllocationContextsAllocating(RepositoryComponent component) {
        ArrayList<AllocationContext> result = new ArrayList<AllocationContext>();
        for (AllocationContext ac : this.getAllAllocationContexts()) {
            if (!this.allocationContextAllocating(ac, component)) continue;
            result.add(ac);
        }
        return result;
    }

    private boolean allocationContextAllocating(AllocationContext alloc, RepositoryComponent component) {
        return FCCUtil.areEqual((EObject)this.getAllocatedComponentOf(alloc), (EObject)component);
    }

    private RepositoryComponent getAllocatedComponentOf(AllocationContext alloc) {
        return alloc.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext();
    }

    public boolean existAllocationContextWith(AssemblyContext assemblyContext) {
        for (AllocationContext ac : this.getAllAllocationContexts()) {
            if (!this.isAllocated(ac, assemblyContext)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllocated(AllocationContext alloc, AssemblyContext assemblyContext) {
        return FCCUtil.areEqual((EObject)alloc.getAssemblyContext_AllocationContext(), (EObject)assemblyContext);
    }

    public void addAllocationContext(AllocationContext allocationContext) {
        this.allocation.getAllocationContexts_Allocation().add((Object)allocationContext);
    }

    public AllocationContext createAllocationContextBy(AssemblyContext assemblyContext, ResourceContainer resourceContainer) {
        AllocationContext allocationContext = AllocationFactory.eINSTANCE.createAllocationContext();
        allocationContext.setEntityName(String.format("%1s_Allocation", assemblyContext.getEntityName()));
        allocationContext.setAssemblyContext_AllocationContext(assemblyContext);
        allocationContext.setResourceContainer_AllocationContext(resourceContainer);
        return allocationContext;
    }
}

