/*
 * Decompiled with CFR 0.152.
 */
package FeatureCompletionModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Constraint implements Enumerator
{
    ANY(0, "ANY", "ANY"),
    TOGETHER(1, "TOGETHER", "TOGETHER"),
    ISOLATED(2, "ISOLATED", "ISOLATED"),
    SEPARATED(3, "SEPARATED", "SEPARATED");

    public static final int ANY_VALUE = 0;
    public static final int TOGETHER_VALUE = 1;
    public static final int ISOLATED_VALUE = 2;
    public static final int SEPARATED_VALUE = 3;
    private static final Constraint[] VALUES_ARRAY;
    public static final List<Constraint> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Constraint[]{ANY, TOGETHER, ISOLATED, SEPARATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Constraint get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Constraint result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Constraint getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Constraint result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Constraint get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return TOGETHER;
            }
            case 2: {
                return ISOLATED;
            }
            case 3: {
                return SEPARATED;
            }
        }
        return null;
    }

    private Constraint(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

