/*
 * Decompiled with CFR 0.152.
 */
package featureObjective.util;

import featureObjective.AttributeTypes;
import featureObjective.Constraint;
import featureObjective.Feature;
import featureObjective.FeatureGroup;
import featureObjective.FeatureObjective;
import featureObjective.FeatureObjectivePackage;
import featureObjective.LogicalOperation;
import featureObjective.ProhibitsConstraint;
import featureObjective.RequiredConstraint;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class FeatureObjectiveValidator
extends EObjectValidator {
    public static final FeatureObjectiveValidator INSTANCE = new FeatureObjectiveValidator();
    public static final String DIAGNOSTIC_SOURCE = "featureObjective";
    public static final int FEATURE_GROUP__XO_ROR_OR_IMPLIES_CHILDREN_ARE_MANDATORY = 1;
    public static final int FEATURE_GROUP__ALL_IMPLIES_CARDINALITIES_TO_BE_MINUS_ONE = 2;
    public static final int FEATURE_GROUP__OR_IMPLIES_CARDINALITIES_MIN_TO_BE_ONE_AND_MAX_TO_BE_MINUS_ONE = 3;
    public static final int FEATURE_GROUP__XOR_IMPLIES_CARDINALITIES_TO_BE_ONE = 4;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 4;
    protected static final int DIAGNOSTIC_CODE_COUNT = 4;

    protected EPackage getEPackage() {
        return FeatureObjectivePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFeatureObjective((FeatureObjective)value, diagnostics, context);
            }
            case 1: {
                return this.validateFeature((Feature)value, diagnostics, context);
            }
            case 2: {
                return this.validateFeatureGroup((FeatureGroup)value, diagnostics, context);
            }
            case 3: {
                return this.validateConstraint((Constraint)value, diagnostics, context);
            }
            case 4: {
                return this.validateRequiredConstraint((RequiredConstraint)value, diagnostics, context);
            }
            case 5: {
                return this.validateProhibitsConstraint((ProhibitsConstraint)value, diagnostics, context);
            }
            case 6: {
                return this.validateAttributeTypes((AttributeTypes)((Object)value), diagnostics, context);
            }
            case 7: {
                return this.validateLogicalOperation((LogicalOperation)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFeatureObjective(FeatureObjective featureObjective, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(featureObjective, diagnostics, context);
    }

    public boolean validateFeature(Feature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(feature, diagnostics, context);
    }

    public boolean validateFeatureGroup(FeatureGroup featureGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(featureGroup, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(featureGroup, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFeatureGroup_XORorORImpliesChildrenAreMandatory(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFeatureGroup_ALLImpliesCardinalitiesToBeMinusOne(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFeatureGroup_ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(featureGroup, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFeatureGroup_XORImpliesCardinalitiesToBeOne(featureGroup, diagnostics, context);
        }
        return result;
    }

    public boolean validateFeatureGroup_XORorORImpliesChildrenAreMandatory(FeatureGroup featureGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return featureGroup.XORorORImpliesChildrenAreMandatory(diagnostics, context);
    }

    public boolean validateFeatureGroup_ALLImpliesCardinalitiesToBeMinusOne(FeatureGroup featureGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return featureGroup.ALLImpliesCardinalitiesToBeMinusOne(diagnostics, context);
    }

    public boolean validateFeatureGroup_ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(FeatureGroup featureGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return featureGroup.ORImpliesCardinalitiesMinToBeOneAndMaxToBeMinusOne(diagnostics, context);
    }

    public boolean validateFeatureGroup_XORImpliesCardinalitiesToBeOne(FeatureGroup featureGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return featureGroup.XORImpliesCardinalitiesToBeOne(diagnostics, context);
    }

    public boolean validateConstraint(Constraint constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(constraint, diagnostics, context);
    }

    public boolean validateRequiredConstraint(RequiredConstraint requiredConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(requiredConstraint, diagnostics, context);
    }

    public boolean validateProhibitsConstraint(ProhibitsConstraint prohibitsConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(prohibitsConstraint, diagnostics, context);
    }

    public boolean validateAttributeTypes(AttributeTypes attributeTypes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLogicalOperation(LogicalOperation logicalOperation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

