/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.processes.IWaitingProcess;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.ExactSchedulingFactory;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ActiveProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessRegistry;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.impl.ProcessWithPriority;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.active.SimResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.passive.WaitingProcess;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.strategy.IScheduler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.log4j.Logger;
import scheduler.configuration.ActiveResourceConfiguration;
import scheduler.configuration.ConfigurationFactory;
import scheduler.configuration.PriorityClass;
import scheduler.configuration.ProcessConfiguration;

public class SimActiveResource
extends AbstractActiveResource {
    private IScheduler scheduler;
    private final List<IResourceInstance> instanceList;
    private final ProcessRegistry processRegistry;
    private final IResourceInstance main_instance;
    private final Deque<IWaitingProcess> waiting_queue = new ArrayDeque<IWaitingProcess>();
    private ExactSchedulingFactory exactSchedulingFactory = null;
    private ActiveResourceConfiguration resourceConf = null;
    public static final Logger logger = Logger.getLogger((String)"Scheduler");

    public SimActiveResource(ExactSchedulingFactory exactSchedulingFactory, SchedulerModel model, ActiveResourceConfiguration resourceConf, IResourceTableManager resourceTableManager) {
        super(model, (long)resourceConf.getReplicas(), resourceConf.getName(), resourceConf.getId(), resourceTableManager);
        this.resourceConf = resourceConf;
        this.instanceList = new ArrayList<IResourceInstance>();
        this.processRegistry = new ProcessRegistry(this);
        this.exactSchedulingFactory = exactSchedulingFactory;
        int i = 0;
        while ((long)i < this.capacity) {
            this.instanceList.add(exactSchedulingFactory.createResourceInstance(i, (IActiveResource)this));
            ++i;
        }
        this.main_instance = this.instanceList.get(0);
        logger.warn((Object)("Note that the used exact scheduler " + this.resourceConf.getName() + "assumes that resource demands are specified in milliseconds."));
    }

    public IScheduler getScheduler() {
        return this.scheduler;
    }

    public List<IResourceInstance> getInstanceList() {
        return this.instanceList;
    }

    public IActiveProcess lookUp(ISchedulableProcess process) {
        IActiveProcess p = this.processRegistry.lookUp(process);
        if (p == null) {
            ISchedulableProcess parent = process;
            IActiveProcess pparent = null;
            int i = 0;
            do {
                parent = parent.getRootProcess();
                pparent = this.processRegistry.lookUp(parent);
                ++i;
            } while (pparent == null && parent != null);
            assert (pparent != null);
            assert (i < 2);
            p = pparent.createNewInstance(process);
            this.processRegistry.registerProcess(p);
        }
        return p;
    }

    public void doProcessing(ISchedulableProcess sched_process, int resourceServiceID, double demand) {
        IActiveProcess process = this.lookUp(sched_process);
        LoggingWrapper.log((String)(" Process " + process + " demands " + MathTools.round((double)demand, (double)0.01)));
        process.setCurrentDemand(demand);
        this.scheduler.scheduleNextEvent(process.getLastInstance());
        sched_process.passivate();
    }

    public void start() {
        for (IResourceInstance instance : this.instanceList) {
            instance.start();
        }
    }

    public boolean isIdle(IResourceInstance instance) {
        return this.scheduler.isIdle(instance);
    }

    public void setScheduler(IScheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void dequeue(ISchedulableProcess process) {
        ActiveProcess myProcess = (ActiveProcess)this.lookUp(process);
        WaitingProcess waiting_process = new WaitingProcess(myProcess, 0L);
        this.scheduler.fromRunningToWaiting(waiting_process, this.waiting_queue, false);
    }

    protected void enqueue(ISchedulableProcess process) {
        WaitingProcess waiting_process = this.lookUpWaitingProcess(process);
        if (waiting_process != null) {
            IResourceInstance instance = this.getInstanceFor(waiting_process.getActiveProcess());
            this.scheduler.fromWaitingToReady(waiting_process, this.waiting_queue, instance);
        } else {
            IActiveProcess p = this.lookUp(process);
            IResourceInstance instance = this.getInstanceFor(p);
            this.scheduler.forkNewProcess(p, instance);
            instance.schedulingInterrupt(0.0);
        }
    }

    private IResourceInstance getInstanceFor(IActiveProcess process) {
        IResourceInstance instance = this.main_instance;
        if (process.hasIdealInstance()) {
            instance = process.getIdealInstance();
        }
        if (process.hasLastInstance()) {
            instance = process.getLastInstance();
        }
        return instance;
    }

    private WaitingProcess lookUpWaitingProcess(ISchedulableProcess process) {
        for (IWaitingProcess p : this.waiting_queue) {
            if (!((WaitingProcess)p).getActiveProcess().getSchedulableProcess().equals(process)) continue;
            return (WaitingProcess)p;
        }
        return null;
    }

    public void stop() {
        for (IResourceInstance ri : this.instanceList) {
            ri.stop();
        }
    }

    public double getRemainingDemand(ISchedulableProcess process) {
        throw new UnsupportedOperationException("getRemainingDemand() not yet supported!");
    }

    public void updateDemand(ISchedulableProcess process, double demand) {
        throw new UnsupportedOperationException("updateDemand() not yet supported!");
    }

    public void registerProcess(ISchedulableProcess schedulableProcess) {
        ProcessConfiguration processConf = ConfigurationFactory.eINSTANCE.createProcessConfiguration();
        processConf.setName(schedulableProcess.getId());
        processConf.setPriority(PriorityClass.DEFAULT);
        processConf.setReplicas(1);
        ProcessWithPriority p = (ProcessWithPriority)this.exactSchedulingFactory.createRunningProcess(schedulableProcess, processConf, this.resourceConf);
        if (!this.processRegistry.isRegistered(p)) {
            this.processRegistry.registerProcess(p);
            IResourceInstance instance = this.getInstanceFor(p);
            this.scheduler.registerProcess(p, instance);
            p.getSchedulableProcess().addTerminatedObserver((IActiveResource)this);
        }
    }

    public void unregisterProcess(IActiveProcess process) {
        this.processRegistry.unregisterProcess(process.getSchedulableProcess());
    }

    public void addObserver(IActiveResourceStateSensor observer) {
        for (IResourceInstance instance : this.instanceList) {
            instance.addObserver(observer);
        }
    }

    public IActiveProcess findProcess(String processName) {
        return this.processRegistry.findProcess(processName);
    }

    public void notifyTerminated(ISchedulableProcess simProcess) {
        super.notifyTerminated(simProcess);
        IActiveProcess activeProcess = this.lookUp(simProcess);
        IResourceInstance instance = activeProcess.getLastInstance();
        this.getScheduler().terminateProcess(activeProcess, instance);
        simProcess.removeTerminatedObserver((IActiveResource)this);
    }

    public int getQueueLengthFor(SchedulerEntity schedulerEntity, int coreId) {
        assert (schedulerEntity instanceof SimResourceInstance);
        return this.scheduler.getQueueLengthFor((SimResourceInstance)this.getInstanceList().get(coreId));
    }
}

